
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;

/** 
 * Any payment that is collected by the agent and settled between the Airline and the agent. Refer to IATA Resolution 728 Attachment A for full details.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CashType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PostalAddressType" name="CollectionAddress" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CashType implements Serializable
{
    private PostalAddressType collectionAddress;

    /** 
     * Get the 'CollectionAddress' element value. Natural or physical address used for postal service. May be a building address, airport address, etc.
     * 
     * @return value
     */
    public PostalAddressType getCollectionAddress() {
        return collectionAddress;
    }

    /** 
     * Set the 'CollectionAddress' element value. Natural or physical address used for postal service. May be a building address, airport address, etc.
     * 
     * @param collectionAddress
     */
    public void setCollectionAddress(PostalAddressType collectionAddress) {
        this.collectionAddress = collectionAddress;
    }
}
