
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * Pre-defined code set metadata.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CodesetMetadataType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CodesetName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="CodesetVersionNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:LangUsageType" name="LangUsage" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OwnerID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OwnerName" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CodesetMetadataType implements Serializable
{
    private String codesetName;
    private BigDecimal codesetVersionNumber;
    private LangUsageType langUsage;
    private String ownerID;
    private String ownerName;

    /** 
     * Get the 'CodesetName' element value. Name of the codeset (e.g. PADIS Codeset)
     * 
     * @return value
     */
    public String getCodesetName() {
        return codesetName;
    }

    /** 
     * Set the 'CodesetName' element value. Name of the codeset (e.g. PADIS Codeset)
     * 
     * @param codesetName
     */
    public void setCodesetName(String codesetName) {
        this.codesetName = codesetName;
    }

    /** 
     * Get the 'CodesetVersionNumber' element value. Codeset version number. Ex: 14
     * 
     * @return value
     */
    public BigDecimal getCodesetVersionNumber() {
        return codesetVersionNumber;
    }

    /** 
     * Set the 'CodesetVersionNumber' element value. Codeset version number. Ex: 14
     * 
     * @param codesetVersionNumber
     */
    public void setCodesetVersionNumber(BigDecimal codesetVersionNumber) {
        this.codesetVersionNumber = codesetVersionNumber;
    }

    /** 
     * Get the 'LangUsage' element value. Language Code representation.
     * 
     * @return value
     */
    public LangUsageType getLangUsage() {
        return langUsage;
    }

    /** 
     * Set the 'LangUsage' element value. Language Code representation.
     * 
     * @param langUsage
     */
    public void setLangUsage(LangUsageType langUsage) {
        this.langUsage = langUsage;
    }

    /** 
     * Get the 'OwnerID' element value. Owner entity ID.  Example: BA
     * 
     * @return value
     */
    public String getOwnerID() {
        return ownerID;
    }

    /** 
     * Set the 'OwnerID' element value. Owner entity ID.  Example: BA
     * 
     * @param ownerID
     */
    public void setOwnerID(String ownerID) {
        this.ownerID = ownerID;
    }

    /** 
     * Get the 'OwnerName' element value. Owner Entity Name. Ex: British Airways
     * 
     * @return value
     */
    public String getOwnerName() {
        return ownerName;
    }

    /** 
     * Set the 'OwnerName' element value. Owner Entity Name. Ex: British Airways
     * 
     * @param ownerName
     */
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }
}
