
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;

/** 
 * Tax data breakdown by collection point for XF(Passenger Facility Fee) and ZP(federal tax segment) taxes.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CollectionPointTaxType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AmountType" name="AirportAmount" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="AirportCur" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:StationType" name="Station" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CollectionPointTaxType implements Serializable
{
    private AmountType airportAmount;
    private String airportCur;
    private StationType station;

    /** 
     * Get the 'AirportAmount' element value. Amount filed by the airport in the currency applicable to the geographical location of the airport.
     * 
     * @return value
     */
    public AmountType getAirportAmount() {
        return airportAmount;
    }

    /** 
     * Set the 'AirportAmount' element value. Amount filed by the airport in the currency applicable to the geographical location of the airport.
     * 
     * @param airportAmount
     */
    public void setAirportAmount(AmountType airportAmount) {
        this.airportAmount = airportAmount;
    }

    /** 
     * Get the 'AirportCur' element value.
     * 
     * @return value
     */
    public String getAirportCur() {
        return airportCur;
    }

    /** 
     * Set the 'AirportCur' element value.
     * 
     * @param airportCur
     */
    public void setAirportCur(String airportCur) {
        this.airportCur = airportCur;
    }

    /** 
     * Get the 'Station' element value. Location or facility where air or surface transportation originates, stops and/or terminates, and where passengers and/or cargo can be taken on or off.
     * 
     * @return value
     */
    public StationType getStation() {
        return station;
    }

    /** 
     * Set the 'Station' element value. Location or facility where air or surface transportation originates, stops and/or terminates, and where passengers and/or cargo can be taken on or off.
     * 
     * @param station
     */
    public void setStation(StationType station) {
        this.station = station;
    }
}
