
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Deduction from the price amount, made in advance of its payment.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DiscountType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AppText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="DescText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:AmountType" name="DiscountAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:KeyValuePropertyType" name="DiscountContext" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PercentType" name="DiscountPercent" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:AmountType" name="PreDiscountedAmount" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DiscountType implements Serializable
{
    private String appText;
    private String descText;
    private AmountType discountAmount;
    private List<KeyValuePropertyType> discountContextList = new ArrayList<KeyValuePropertyType>();
    private PercentType discountPercent;
    private AmountType preDiscountedAmount;

    /** 
     * Get the 'AppText' element value. Discount application, e.g. Bag.
     * 
     * @return value
     */
    public String getAppText() {
        return appText;
    }

    /** 
     * Set the 'AppText' element value. Discount application, e.g. Bag.
     * 
     * @param appText
     */
    public void setAppText(String appText) {
        this.appText = appText;
    }

    /** 
     * Get the 'DescText' element value. Discount Description.
     * 
     * @return value
     */
    public String getDescText() {
        return descText;
    }

    /** 
     * Set the 'DescText' element value. Discount Description.
     * 
     * @param descText
     */
    public void setDescText(String descText) {
        this.descText = descText;
    }

    /** 
     * Get the 'DiscountAmount' element value. Discount amount applied to a price.
     * 
     * @return value
     */
    public AmountType getDiscountAmount() {
        return discountAmount;
    }

    /** 
     * Set the 'DiscountAmount' element value. Discount amount applied to a price.
     * 
     * @param discountAmount
     */
    public void setDiscountAmount(AmountType discountAmount) {
        this.discountAmount = discountAmount;
    }

    /** 
     * Get the list of 'DiscountContext' element items. Contextual information to further describe something using a key-value pair.
     * 
     * @return list
     */
    public List<KeyValuePropertyType> getDiscountContextList() {
        return discountContextList;
    }

    /** 
     * Set the list of 'DiscountContext' element items. Contextual information to further describe something using a key-value pair.
     * 
     * @param list
     */
    public void setDiscountContextList(List<KeyValuePropertyType> list) {
        discountContextList = list;
    }

    /** 
     * Get the 'DiscountPercent' element value. Discount percentage applied to the price.
     * 
     * @return value
     */
    public PercentType getDiscountPercent() {
        return discountPercent;
    }

    /** 
     * Set the 'DiscountPercent' element value. Discount percentage applied to the price.
     * 
     * @param discountPercent
     */
    public void setDiscountPercent(PercentType discountPercent) {
        this.discountPercent = discountPercent;
    }

    /** 
     * Get the 'PreDiscountedAmount' element value. The original price on which the discount was applied to.
     * 
     * @return value
     */
    public AmountType getPreDiscountedAmount() {
        return preDiscountedAmount;
    }

    /** 
     * Set the 'PreDiscountedAmount' element value. The original price on which the discount was applied to.
     * 
     * @param preDiscountedAmount
     */
    public void setPreDiscountedAmount(AmountType preDiscountedAmount) {
        this.preDiscountedAmount = preDiscountedAmount;
    }
}
