
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Refers to the Passengers, Price class or segments for which this offer item is eligible.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EligibilityType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:FlightAssociationsType" name="FlightAssociations" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PaxRefID" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="PriceClassRefID" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class EligibilityType implements Serializable
{
    private FlightAssociationsType flightAssociations;
    private List<String> paxRefIDList = new ArrayList<String>();
    private List<String> priceClassRefIDList = new ArrayList<String>();

    /** 
     * Get the 'FlightAssociations' element value. Eligiibility of this offer item to the following segments or journeys.
     * 
     * @return value
     */
    public FlightAssociationsType getFlightAssociations() {
        return flightAssociations;
    }

    /** 
     * Set the 'FlightAssociations' element value. Eligiibility of this offer item to the following segments or journeys.
     * 
     * @param flightAssociations
     */
    public void setFlightAssociations(FlightAssociationsType flightAssociations) {
        this.flightAssociations = flightAssociations;
    }

    /** 
     * Get the list of 'PaxRefID' element items. Reference to the passengers who are elibigle for this Offer Item
     * 
     * @return list
     */
    public List<String> getPaxRefIDList() {
        return paxRefIDList;
    }

    /** 
     * Set the list of 'PaxRefID' element items. Reference to the passengers who are elibigle for this Offer Item
     * 
     * @param list
     */
    public void setPaxRefIDList(List<String> list) {
        paxRefIDList = list;
    }

    /** 
     * Get the list of 'PriceClassRefID' element items. Reference to the Price Class for which this Offer Item can be provided.
     * 
     * @return list
     */
    public List<String> getPriceClassRefIDList() {
        return priceClassRefIDList;
    }

    /** 
     * Set the list of 'PriceClassRefID' element items. Reference to the Price Class for which this Offer Item can be provided.
     * 
     * @param list
     */
    public void setPriceClassRefIDList(List<String> list) {
        priceClassRefIDList = list;
    }
}
