
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareDetailType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AccountCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:FareComponentType" name="FareComponent" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="FareIndCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:FarePriceTypeType" name="FarePriceType" minOccurs="1" maxOccurs="3"/>
 *     &lt;xs:element type="xs:string" name="FareRefText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="FiledFareInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="NetReportingCodeText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PaxRefID" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="PricingSystemCodeText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="StatisticalCodeText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TourCode" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareDetailType implements Serializable
{
    private String accountCode;
    private List<FareComponentType> fareComponentList = new ArrayList<FareComponentType>();
    private String fareIndCode;
    private List<FarePriceTypeType> farePriceTypeList = new ArrayList<FarePriceTypeType>();
    private String fareRefText;
    private Boolean filedFareInd;
    private String netReportingCodeText;
    private List<String> paxRefIDList = new ArrayList<String>();
    private String pricingSystemCodeText;
    private String statisticalCodeText;
    private String tourCode;

    /** 
     * Get the 'AccountCode' element value. Corporate ID used for pricing special fares.  Example: 675124
     * 
     * @return value
     */
    public String getAccountCode() {
        return accountCode;
    }

    /** 
     * Set the 'AccountCode' element value. Corporate ID used for pricing special fares.  Example: 675124
     * 
     * @param accountCode
     */
    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    /** 
     * Get the list of 'FareComponent' element items. A portion of an itinerary between two consecutive fare construction points.  If the journey has only one fare component, the points of origin and destination are the only fare construction points
     * 
     * @return list
     */
    public List<FareComponentType> getFareComponentList() {
        return fareComponentList;
    }

    /** 
     * Set the list of 'FareComponent' element items. A portion of an itinerary between two consecutive fare construction points.  If the journey has only one fare component, the points of origin and destination are the only fare construction points
     * 
     * @param list
     */
    public void setFareComponentList(List<FareComponentType> list) {
        fareComponentList = list;
    }

    /** 
     * Get the 'FareIndCode' element value. Fare indicator code.  Example: 1 (SYSTEM PRICED WITHOUT MANUAL INTERVENTION)  Encoding Scheme: IATA PADIS Code List for data element 5387 - Price Type Qualifier
     * 
     * @return value
     */
    public String getFareIndCode() {
        return fareIndCode;
    }

    /** 
     * Set the 'FareIndCode' element value. Fare indicator code.  Example: 1 (SYSTEM PRICED WITHOUT MANUAL INTERVENTION)  Encoding Scheme: IATA PADIS Code List for data element 5387 - Price Type Qualifier
     * 
     * @param fareIndCode
     */
    public void setFareIndCode(String fareIndCode) {
        this.fareIndCode = fareIndCode;
    }

    /** 
     * Get the list of 'FarePriceType' element items. The type of fair price applied to a Fare Detail (e.g. filed amount, net amount, or a sell amount).
     * 
     * @return list
     */
    public List<FarePriceTypeType> getFarePriceTypeList() {
        return farePriceTypeList;
    }

    /** 
     * Set the list of 'FarePriceType' element items. The type of fair price applied to a Fare Detail (e.g. filed amount, net amount, or a sell amount).
     * 
     * @param list
     */
    public void setFarePriceTypeList(List<FarePriceTypeType> list) {
        farePriceTypeList = list;
    }

    /** 
     * Get the 'FareRefText' element value. Fare reference key, ex: PQ123456
     * 
     * @return value
     */
    public String getFareRefText() {
        return fareRefText;
    }

    /** 
     * Set the 'FareRefText' element value. Fare reference key, ex: PQ123456
     * 
     * @param fareRefText
     */
    public void setFareRefText(String fareRefText) {
        this.fareRefText = fareRefText;
    }

    /** 
     * Get the 'FiledFareInd' element value. When TRUE, a component of this fare has been priced using filed fare data.  If FALSE, dynamic pricing has been applied.
     * 
     * @return value
     */
    public Boolean getFiledFareInd() {
        return filedFareInd;
    }

    /** 
     * Set the 'FiledFareInd' element value. When TRUE, a component of this fare has been priced using filed fare data.  If FALSE, dynamic pricing has been applied.
     * 
     * @param filedFareInd
     */
    public void setFiledFareInd(Boolean filedFareInd) {
        this.filedFareInd = filedFareInd;
    }

    /** 
     * Get the 'NetReportingCodeText' element value. Code indicating if the transaction is subject to a net reporting arrangement.
     * 
     * @return value
     */
    public String getNetReportingCodeText() {
        return netReportingCodeText;
    }

    /** 
     * Set the 'NetReportingCodeText' element value. Code indicating if the transaction is subject to a net reporting arrangement.
     * 
     * @param netReportingCodeText
     */
    public void setNetReportingCodeText(String netReportingCodeText) {
        this.netReportingCodeText = netReportingCodeText;
    }

    /** 
     * Get the list of 'PaxRefID' element items. Reference to a Passenger ID
     * 
     * @return list
     */
    public List<String> getPaxRefIDList() {
        return paxRefIDList;
    }

    /** 
     * Set the list of 'PaxRefID' element items. Reference to a Passenger ID
     * 
     * @param list
     */
    public void setPaxRefIDList(List<String> list) {
        paxRefIDList = list;
    }

    /** 
     * Get the 'PricingSystemCodeText' element value. IATA assigned code identifying the system used to price the itinerary for the document being issued.
     * 
     * @return value
     */
    public String getPricingSystemCodeText() {
        return pricingSystemCodeText;
    }

    /** 
     * Set the 'PricingSystemCodeText' element value. IATA assigned code identifying the system used to price the itinerary for the document being issued.
     * 
     * @param pricingSystemCodeText
     */
    public void setPricingSystemCodeText(String pricingSystemCodeText) {
        this.pricingSystemCodeText = pricingSystemCodeText;
    }

    /** 
     * Get the 'StatisticalCodeText' element value. Code used for domestic or international sales differentiation.
     * 
     * @return value
     */
    public String getStatisticalCodeText() {
        return statisticalCodeText;
    }

    /** 
     * Set the 'StatisticalCodeText' element value. Code used for domestic or international sales differentiation.
     * 
     * @param statisticalCodeText
     */
    public void setStatisticalCodeText(String statisticalCodeText) {
        this.statisticalCodeText = statisticalCodeText;
    }

    /** 
     * Get the 'TourCode' element value. Tour Code. Example: ITGF12
     * 
     * @return value
     */
    public String getTourCode() {
        return tourCode;
    }

    /** 
     * Set the 'TourCode' element value. Tour Code. Example: ITGF12
     * 
     * @param tourCode
     */
    public void setTourCode(String tourCode) {
        this.tourCode = tourCode;
    }
}
