
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

/** 
 * The OrderReshop transaction set passes new shopping requests to an airline to replace existing specified order or order items in an Order or for new shopping requests to add to an existing Order. Airline responds with product offers within the context of the existing Order.

 There is no change to the Order or Order Items, in response to a Reshop request - typically, the Reshop response will be followed by an OrderChangeRQ or OrderCancelRQ transaction, to commit the re-shop offer.

 In the response, the Airline can provide exact instructions as to what actions can finally be executed, as a solution to the initially requested action.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IATA_OrderReshopRS">
 *   &lt;xs:key name="PenaltyIDKey">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:PenaltyList/k:Penalty"/>
 *     &lt;xs:field xpath="k:PenaltyID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:PenaltyIDKey" name="PenaltyIDKeyRef">
 *     &lt;xs:selector xpath="./k:Response/k:ChangeFees/k:PenaltyRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PenaltyIDKey" name="PenaltyIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:FareList/k:FareGroup/k:FareDetail/k:FareComponent/k:FareRule/k:PenaltyRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="PaxSegmentIDKey">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:PaxSegmentList/k:PaxSegment"/>
 *     &lt;xs:field xpath="k:PaxSegmentID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:PaxSegmentIDKey" name="PaxSegmentIDKeyRef">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:FareList/k:FareGroup/k:FareDetail/k:FareComponent/k:PaxSegmentRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="PriceClassIDKey">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:PriceClassList/k:PriceClass"/>
 *     &lt;xs:field xpath="k:PriceClassID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:PriceClassIDKey" name="PriceClassIDKeyRef">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:FareList/k:FareGroup/k:FareDetail/k:FareComponent/k:PriceClassRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="PaxIDKey">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:PaxList/k:Pax"/>
 *     &lt;xs:field xpath="k:PaxID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:PaxIDKey" name="PaxIDKeyRef">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:FareList/k:FareGroup/k:FareDetail/k:PaxRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="PaxJourneyIDKey">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:PaxJourneyList/k:PaxJourney"/>
 *     &lt;xs:field xpath="k:PaxJourneyID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:PaxJourneyIDKey" name="PaxJourneyIDKeyRef">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:OriginDestList/k:OriginDest/k:PaxJourneyRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxSegmentIDKey" name="PaxSegmentIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:PaxJourneyList/k:PaxJourney/k:PaxSegmentRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="ContactInfoIDKey">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:ContactInfoList/k:ContactInfo"/>
 *     &lt;xs:field xpath="k:ContactInfoID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:PaxList/k:Pax/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxIDKey" name="PaxIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:PaxList/k:Pax/k:PaxRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="DisclosureIDKey">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:DisclosureList/k:Disclosure"/>
 *     &lt;xs:field xpath="k:DisclosureID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:DisclosureIDKey" name="DisclosureIDKeyRef">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:PaxSegmentList/k:PaxSegment/k:OperatingCarrierInfo/k:DisclosureRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="BaggageAllowanceIDKey">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:BaggageAllowanceList/k:BaggageAllowance"/>
 *     &lt;xs:field xpath="k:BaggageAllowanceID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:BaggageAllowanceIDKey" name="BaggageAllowanceIDKeyRef">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:ServiceDefinitionList/k:ServiceDefinition/k:ServiceDefinitionAssociation/k:BaggageAllowanceRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="SeatProfileIDKey">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:SeatProfileList/k:SeatProfile"/>
 *     &lt;xs:field xpath="k:SeatProfileID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:SeatProfileIDKey" name="SeatProfileIDKeyRef">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:ServiceDefinitionList/k:ServiceDefinition/k:ServiceDefinitionAssociation/k:SeatProfileRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="ServiceDefinitionIDKey">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:ServiceDefinitionList/k:ServiceDefinition"/>
 *     &lt;xs:field xpath="k:ServiceDefinitionID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:ServiceDefinitionIDKey" name="ServiceDefinitionIDKeyRef">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:ServiceDefinitionList/k:ServiceDefinition/k:ServiceDefinitionAssociation/k:ServiceBundle/k:ServiceDefinitionRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Response/k:PaxGroup/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef2">
 *     &lt;xs:selector xpath="./k:Response/k:PaymentInfo/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef3">
 *     &lt;xs:selector xpath="./k:Response/k:PaymentInfo/k:PaymentMethod/k:DirectBill/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxIDKey" name="PaxIDKeyRef2">
 *     &lt;xs:selector xpath="./k:Response/k:PaymentInfo/k:Promotion/k:PaxRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef4">
 *     &lt;xs:selector xpath="./k:Response/k:PaymentInfo/k:Promotion/k:PromotionIssuer/k:Org/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef5">
 *     &lt;xs:selector xpath="./k:Response/k:PaymentInfo/k:Promotion/k:PromotionIssuer/k:TravelAgency/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PenaltyIDKey" name="PenaltyIDKeyRef2">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:RepricedOffer/k:RepricedOfferItem/k:FareDetail/k:FareComponent/k:FareRule/k:PenaltyRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxSegmentIDKey" name="PaxSegmentIDKeyRef2">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:RepricedOffer/k:RepricedOfferItem/k:FareDetail/k:FareComponent/k:PaxSegmentRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PriceClassIDKey" name="PriceClassIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:RepricedOffer/k:RepricedOfferItem/k:FareDetail/k:FareComponent/k:PriceClassRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxIDKey" name="PaxIDKeyRef3">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:RepricedOffer/k:RepricedOfferItem/k:FareDetail/k:PaxRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PenaltyIDKey" name="PenaltyIDKeyRef3">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:RepricedOffer/k:RepricedOfferItem/k:OriginalOrderItem/k:FareDetail/k:FareComponent/k:FareRule/k:PenaltyRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxSegmentIDKey" name="PaxSegmentIDKeyRef3">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:RepricedOffer/k:RepricedOfferItem/k:OriginalOrderItem/k:FareDetail/k:FareComponent/k:PaxSegmentRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PriceClassIDKey" name="PriceClassIDKeyRef2">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:RepricedOffer/k:RepricedOfferItem/k:OriginalOrderItem/k:FareDetail/k:FareComponent/k:PriceClassRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxIDKey" name="PaxIDKeyRef4">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:RepricedOffer/k:RepricedOfferItem/k:OriginalOrderItem/k:FareDetail/k:PaxRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="DatedOperatingLegIDKey">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:PaxSegmentList/k:PaxSegment/k:DatedOperatingLeg"/>
 *     &lt;xs:field xpath="k:DatedOperatingLegID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:DatedOperatingLegIDKey" name="DatedOperatingLegIDKeyRef">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:ALaCarteOffer/k:ALaCarteOfferItem/k:Eligibility/k:FlightAssociations/k:DatedOperatingLegRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxJourneyIDKey" name="PaxJourneyIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:ALaCarteOffer/k:ALaCarteOfferItem/k:Eligibility/k:FlightAssociations/k:PaxJourneyRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxSegmentIDKey" name="PaxSegmentIDKeyRef4">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:ALaCarteOffer/k:ALaCarteOfferItem/k:Eligibility/k:FlightAssociations/k:PaxSegmentRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxIDKey" name="PaxIDKeyRef5">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:ALaCarteOffer/k:ALaCarteOfferItem/k:Eligibility/k:PaxRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PriceClassIDKey" name="PriceClassIDKeyRef3">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:ALaCarteOffer/k:ALaCarteOfferItem/k:Eligibility/k:PriceClassRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ServiceDefinitionIDKey" name="ServiceDefinitionIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:ALaCarteOffer/k:ALaCarteOfferItem/k:Service/k:ServiceDefinitionRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="BaggageDisclosureIDKey">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:BaggageDisclosureList/k:BaggageDisclosure"/>
 *     &lt;xs:field xpath="k:BaggageDisclosureID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:BaggageDisclosureIDKey" name="BaggageDisclosureIDKeyRef">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:ALaCarteOffer/k:BaggageDisclosureRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:DisclosureIDKey" name="DisclosureIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:ALaCarteOffer/k:DisclosureRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxJourneyIDKey" name="PaxJourneyIDKeyRef2">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:ALaCarteOffer/k:JourneyOverview/k:JourneyPriceClass/k:PaxJourneyRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PriceClassIDKey" name="PriceClassIDKeyRef4">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:ALaCarteOffer/k:JourneyOverview/k:JourneyPriceClass/k:PriceClassRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PriceClassIDKey" name="PriceClassIDKeyRef5">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:ALaCarteOffer/k:JourneyOverview/k:PriceClassRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PenaltyIDKey" name="PenaltyIDKeyRef4">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:ALaCarteOffer/k:PenaltyRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PenaltyIDKey" name="PenaltyIDKeyRef5">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:Offer/k:AddOfferItem/k:FareDetail/k:FareComponent/k:FareRule/k:PenaltyRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxSegmentIDKey" name="PaxSegmentIDKeyRef5">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:Offer/k:AddOfferItem/k:FareDetail/k:FareComponent/k:PaxSegmentRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PriceClassIDKey" name="PriceClassIDKeyRef6">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:Offer/k:AddOfferItem/k:FareDetail/k:FareComponent/k:PriceClassRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxIDKey" name="PaxIDKeyRef6">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:Offer/k:AddOfferItem/k:FareDetail/k:PaxRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxIDKey" name="PaxIDKeyRef7">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:Offer/k:AddOfferItem/k:Service/k:PaxRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxJourneyIDKey" name="PaxJourneyIDKeyRef3">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:Offer/k:AddOfferItem/k:Service/k:ServiceAssociations/k:PaxJourneyRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:DatedOperatingLegIDKey" name="DatedOperatingLegIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:Offer/k:AddOfferItem/k:Service/k:ServiceAssociations/k:SeatAssignment/k:DatedOperatingLegRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ServiceDefinitionIDKey" name="ServiceDefinitionIDKeyRef2">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:Offer/k:AddOfferItem/k:Service/k:ServiceAssociations/k:SeatAssignment/k:ServiceDefinitionRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ServiceDefinitionIDKey" name="ServiceDefinitionIDKeyRef3">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:Offer/k:AddOfferItem/k:Service/k:ServiceAssociations/k:ServiceDefinitionRef/k:ServiceDefinitionRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:BaggageDisclosureIDKey" name="BaggageDisclosureIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:Offer/k:BaggageDisclosureRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:DisclosureIDKey" name="DisclosureIDKeyRef2">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:Offer/k:DisclosureRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxJourneyIDKey" name="PaxJourneyIDKeyRef4">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:Offer/k:JourneyOverview/k:JourneyPriceClass/k:PaxJourneyRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PriceClassIDKey" name="PriceClassIDKeyRef7">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:Offer/k:JourneyOverview/k:JourneyPriceClass/k:PriceClassRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PriceClassIDKey" name="PriceClassIDKeyRef8">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:Offer/k:JourneyOverview/k:PriceClassRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ServiceDefinitionIDKey" name="ServiceDefinitionIDKeyRef4">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:Offer/k:NameChangeOfferItem/k:NameChangeService/k:ServiceDefinitionRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxIDKey" name="PaxIDKeyRef8">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:Offer/k:NameChangeOfferItem/k:PaxNameChange/k:PaxRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PenaltyIDKey" name="PenaltyIDKeyRef6">
 *     &lt;xs:selector xpath="./k:Response/k:ReshopResults/k:ReshopOffers/k:Offer/k:PenaltyRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:choice>
 *         &lt;xs:element type="ns:ErrorType" name="Error" maxOccurs="unbounded"/>
 *         &lt;xs:element type="ns:ResponseType" name="Response"/>
 *       &lt;/xs:choice>
 *       &lt;xs:element name="AugmentationPoint" minOccurs="0">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:any processContents="lax" namespace="##other"/>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:MessageDocType" name="MessageDoc" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:IATA_PayloadStandardAttributesType" name="PayloadAttributes" minOccurs="0" maxOccurs="1"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class IATAOrderReshopRS implements Serializable
{
    private int choiceSelect = -1;
    private static final int ERROR_LIST_CHOICE = 0;
    private static final int RESPONSE_CHOICE = 1;
    private List<ErrorType> errorList = new ArrayList<ErrorType>();
    private ResponseType response;
    private Element augmentationPoint;
    private MessageDocType messageDoc;
    private IATAPayloadStandardAttributesType payloadAttributes;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if ErrorList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifErrorList() {
        return choiceSelect == ERROR_LIST_CHOICE;
    }

    /** 
     * Get the list of 'Error' element items. Contains information related to errors detected during processing of the preceding request.
     * 
     * @return list
     */
    public List<ErrorType> getErrorList() {
        return errorList;
    }

    /** 
     * Set the list of 'Error' element items. Contains information related to errors detected during processing of the preceding request.
     * 
     * @param list
     */
    public void setErrorList(List<ErrorType> list) {
        setChoiceSelect(ERROR_LIST_CHOICE);
        errorList = list;
    }

    /** 
     * Check if Response is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifResponse() {
        return choiceSelect == RESPONSE_CHOICE;
    }

    /** 
     * Get the 'Response' element value. OrderReshopRS results
     * 
     * @return value
     */
    public ResponseType getResponse() {
        return response;
    }

    /** 
     * Set the 'Response' element value. OrderReshopRS results
     * 
     * @param response
     */
    public void setResponse(ResponseType response) {
        setChoiceSelect(RESPONSE_CHOICE);
        this.response = response;
    }

    /** 
     * Get the 'AugmentationPoint' element value. Implementer-Augmented Structure.
     * 
     * @return value
     */
    public Element getAugmentationPoint() {
        return augmentationPoint;
    }

    /** 
     * Set the 'AugmentationPoint' element value. Implementer-Augmented Structure.
     * 
     * @param augmentationPoint
     */
    public void setAugmentationPoint(Element augmentationPoint) {
        this.augmentationPoint = augmentationPoint;
    }

    /** 
     * Get the 'MessageDoc' element value. Message document information.
     * 
     * @return value
     */
    public MessageDocType getMessageDoc() {
        return messageDoc;
    }

    /** 
     * Set the 'MessageDoc' element value. Message document information.
     * 
     * @param messageDoc
     */
    public void setMessageDoc(MessageDocType messageDoc) {
        this.messageDoc = messageDoc;
    }

    /** 
     * Get the 'PayloadAttributes' element value. IATA Standard Payload Attributes
     * 
     * @return value
     */
    public IATAPayloadStandardAttributesType getPayloadAttributes() {
        return payloadAttributes;
    }

    /** 
     * Set the 'PayloadAttributes' element value. IATA Standard Payload Attributes
     * 
     * @param payloadAttributes
     */
    public void setPayloadAttributes(
            IATAPayloadStandardAttributesType payloadAttributes) {
        this.payloadAttributes = payloadAttributes;
    }
}
