
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Summary of proposed Journey information in the context of this specific Offer.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="JourneyOverviewType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:JourneyPriceClassType" name="JourneyPriceClass" minOccurs="1" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="PriceClassRefID" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class JourneyOverviewType implements Serializable
{
    private List<JourneyPriceClassType> journeyPriceClassList = new ArrayList<JourneyPriceClassType>();
    private String priceClassRefID;

    /** 
     * Get the list of 'JourneyPriceClass' element items. Price class information per Journey.
     * 
     * @return list
     */
    public List<JourneyPriceClassType> getJourneyPriceClassList() {
        return journeyPriceClassList;
    }

    /** 
     * Set the list of 'JourneyPriceClass' element items. Price class information per Journey.
     * 
     * @param list
     */
    public void setJourneyPriceClassList(List<JourneyPriceClassType> list) {
        journeyPriceClassList = list;
    }

    /** 
     * Get the 'PriceClassRefID' element value. Itinerary level Price Class ref
     * 
     * @return value
     */
    public String getPriceClassRefID() {
        return priceClassRefID;
    }

    /** 
     * Set the 'PriceClassRefID' element value. Itinerary level Price Class ref
     * 
     * @param priceClassRefID
     */
    public void setPriceClassRefID(String priceClassRefID) {
        this.priceClassRefID = priceClassRefID;
    }
}
