
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;

/** 
 * A priced grouping of one or more services within an Offer.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NameChangeOfferItemType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:boolean" name="MandatoryInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="ModificationProhibitedInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:NameChangeServiceType" name="NameChangeService" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OfferItemID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaxNameChangeType" name="PaxNameChange" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PriceType" name="Price" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ReshopDifferentialType" name="ReshopDifferential" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class NameChangeOfferItemType implements Serializable
{
    private Boolean mandatoryInd;
    private Boolean modificationProhibitedInd;
    private NameChangeServiceType nameChangeService;
    private String offerItemID;
    private PaxNameChangeType paxNameChange;
    private PriceType price;
    private ReshopDifferentialType reshopDifferential;

    /** 
     * Get the 'MandatoryInd' element value. If set to 'true', indicates mandatory Offer Items which cannot be removed from the Offer.
     * 
     * @return value
     */
    public Boolean getMandatoryInd() {
        return mandatoryInd;
    }

    /** 
     * Set the 'MandatoryInd' element value. If set to 'true', indicates mandatory Offer Items which cannot be removed from the Offer.
     * 
     * @param mandatoryInd
     */
    public void setMandatoryInd(Boolean mandatoryInd) {
        this.mandatoryInd = mandatoryInd;
    }

    /** 
     * Get the 'ModificationProhibitedInd' element value. POA to ORA only: to indicate that the offer is non-modifiable. This indicates to ORA that its offer is non-modifiable (e.g. Regulatory or brand protection reasons). If indicator is set to TRUE, modifications to the POAâ€™s offer ARE NOT allowed.
     * 
     * @return value
     */
    public Boolean getModificationProhibitedInd() {
        return modificationProhibitedInd;
    }

    /** 
     * Set the 'ModificationProhibitedInd' element value. POA to ORA only: to indicate that the offer is non-modifiable. This indicates to ORA that its offer is non-modifiable (e.g. Regulatory or brand protection reasons). If indicator is set to TRUE, modifications to the POAâ€™s offer ARE NOT allowed.
     * 
     * @param modificationProhibitedInd
     */
    public void setModificationProhibitedInd(Boolean modificationProhibitedInd) {
        this.modificationProhibitedInd = modificationProhibitedInd;
    }

    /** 
     * Get the 'NameChangeService' element value. The instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order.
     * 
     * @return value
     */
    public NameChangeServiceType getNameChangeService() {
        return nameChangeService;
    }

    /** 
     * Set the 'NameChangeService' element value. The instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order.
     * 
     * @param nameChangeService
     */
    public void setNameChangeService(NameChangeServiceType nameChangeService) {
        this.nameChangeService = nameChangeService;
    }

    /** 
     * Get the 'OfferItemID' element value. Carrier assigned ID which exists uniquely within an Offer.
     * 
     * @return value
     */
    public String getOfferItemID() {
        return offerItemID;
    }

    /** 
     * Set the 'OfferItemID' element value. Carrier assigned ID which exists uniquely within an Offer.
     * 
     * @param offerItemID
     */
    public void setOfferItemID(String offerItemID) {
        this.offerItemID = offerItemID;
    }

    /** 
     * Get the 'PaxNameChange' element value. Echos back the name changes allowed by the Airline, packaged within an OfferItem.
     * 
     * @return value
     */
    public PaxNameChangeType getPaxNameChange() {
        return paxNameChange;
    }

    /** 
     * Set the 'PaxNameChange' element value. Echos back the name changes allowed by the Airline, packaged within an OfferItem.
     * 
     * @param paxNameChange
     */
    public void setPaxNameChange(PaxNameChangeType paxNameChange) {
        this.paxNameChange = paxNameChange;
    }

    /** 
     * Get the 'Price' element value. The amount of money expected, required, or given in payment for something.
     * 
     * @return value
     */
    public PriceType getPrice() {
        return price;
    }

    /** 
     * Set the 'Price' element value. The amount of money expected, required, or given in payment for something.
     * 
     * @param price
     */
    public void setPrice(PriceType price) {
        this.price = price;
    }

    /** 
     * Get the 'ReshopDifferential' element value. Contains the Original Order amount, new Offer amount, penalty details, fees and due by details. It also contains tax information.
     * 
     * @return value
     */
    public ReshopDifferentialType getReshopDifferential() {
        return reshopDifferential;
    }

    /** 
     * Set the 'ReshopDifferential' element value. Contains the Original Order amount, new Offer amount, penalty details, fees and due by details. It also contains tax information.
     * 
     * @param reshopDifferential
     */
    public void setReshopDifferential(ReshopDifferentialType reshopDifferential) {
        this.reshopDifferential = reshopDifferential;
    }
}
