
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A priced grouping of one or more services within an Offer.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferItemType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ReshopDifferentialType" name="DifferentialAmountDue" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:FareDetailType" name="FareDetail" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:ReshopDifferentialType" name="FeesDifferential" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="MandatoryInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="ModificationProhibitedInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ReshopDifferentialType" name="NewOfferItemDifferential" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OfferItemID"/>
 *     &lt;xs:element type="xs:string" name="OrderItemRefID" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:ReshopDifferentialType" name="OriginalOrderItemDifferential" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaymentTimeLimitType" name="PaymentTimeLimit" minOccurs="0"/>
 *     &lt;xs:element type="ns:ReshopDifferentialType" name="PenaltyDifferential" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PriceType" name="Price" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateTimeType" name="PriceGuaranteeTimeLimitDateTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ServiceType" name="Service" minOccurs="1" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OfferItemType implements Serializable
{
    private ReshopDifferentialType differentialAmountDue;
    private List<FareDetailType> fareDetailList = new ArrayList<FareDetailType>();
    private ReshopDifferentialType feesDifferential;
    private Boolean mandatoryInd;
    private Boolean modificationProhibitedInd;
    private ReshopDifferentialType newOfferItemDifferential;
    private String offerItemID;
    private List<String> orderItemRefIDList = new ArrayList<String>();
    private ReshopDifferentialType originalOrderItemDifferential;
    private PaymentTimeLimitType paymentTimeLimit;
    private ReshopDifferentialType penaltyDifferential;
    private PriceType price;
    private DateTimeType priceGuaranteeTimeLimitDateTime;
    private List<ServiceType> serviceList = new ArrayList<ServiceType>();

    /** 
     * Get the 'DifferentialAmountDue' element value. Contains the Original Order amount, new Offer amount, penalty details, fees and due by details. It also contains tax information.
     * 
     * @return value
     */
    public ReshopDifferentialType getDifferentialAmountDue() {
        return differentialAmountDue;
    }

    /** 
     * Set the 'DifferentialAmountDue' element value. Contains the Original Order amount, new Offer amount, penalty details, fees and due by details. It also contains tax information.
     * 
     * @param differentialAmountDue
     */
    public void setDifferentialAmountDue(
            ReshopDifferentialType differentialAmountDue) {
        this.differentialAmountDue = differentialAmountDue;
    }

    /** 
     * Get the list of 'FareDetail' element items. The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * 
     * @return list
     */
    public List<FareDetailType> getFareDetailList() {
        return fareDetailList;
    }

    /** 
     * Set the list of 'FareDetail' element items. The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * 
     * @param list
     */
    public void setFareDetailList(List<FareDetailType> list) {
        fareDetailList = list;
    }

    /** 
     * Get the 'FeesDifferential' element value. Contains the Original Order amount, new Offer amount, penalty details, fees and due by details. It also contains tax information.
     * 
     * @return value
     */
    public ReshopDifferentialType getFeesDifferential() {
        return feesDifferential;
    }

    /** 
     * Set the 'FeesDifferential' element value. Contains the Original Order amount, new Offer amount, penalty details, fees and due by details. It also contains tax information.
     * 
     * @param feesDifferential
     */
    public void setFeesDifferential(ReshopDifferentialType feesDifferential) {
        this.feesDifferential = feesDifferential;
    }

    /** 
     * Get the 'MandatoryInd' element value. If set to 'true', indicates mandatory Offer Items which cannot be removed from the Offer.
     * 
     * @return value
     */
    public Boolean getMandatoryInd() {
        return mandatoryInd;
    }

    /** 
     * Set the 'MandatoryInd' element value. If set to 'true', indicates mandatory Offer Items which cannot be removed from the Offer.
     * 
     * @param mandatoryInd
     */
    public void setMandatoryInd(Boolean mandatoryInd) {
        this.mandatoryInd = mandatoryInd;
    }

    /** 
     * Get the 'ModificationProhibitedInd' element value. POA to ORA only: to indicate that the offer is non-modifiable. This indicates to ORA that its offer is non-modifiable (e.g. Regulatory or brand protection reasons). If indicator is set to TRUE, modifications to the POAâ€™s offer ARE NOT allowed.
     * 
     * @return value
     */
    public Boolean getModificationProhibitedInd() {
        return modificationProhibitedInd;
    }

    /** 
     * Set the 'ModificationProhibitedInd' element value. POA to ORA only: to indicate that the offer is non-modifiable. This indicates to ORA that its offer is non-modifiable (e.g. Regulatory or brand protection reasons). If indicator is set to TRUE, modifications to the POAâ€™s offer ARE NOT allowed.
     * 
     * @param modificationProhibitedInd
     */
    public void setModificationProhibitedInd(Boolean modificationProhibitedInd) {
        this.modificationProhibitedInd = modificationProhibitedInd;
    }

    /** 
     * Get the 'NewOfferItemDifferential' element value. Contains the Original Order amount, new Offer amount, penalty details, fees and due by details. It also contains tax information.
     * 
     * @return value
     */
    public ReshopDifferentialType getNewOfferItemDifferential() {
        return newOfferItemDifferential;
    }

    /** 
     * Set the 'NewOfferItemDifferential' element value. Contains the Original Order amount, new Offer amount, penalty details, fees and due by details. It also contains tax information.
     * 
     * @param newOfferItemDifferential
     */
    public void setNewOfferItemDifferential(
            ReshopDifferentialType newOfferItemDifferential) {
        this.newOfferItemDifferential = newOfferItemDifferential;
    }

    /** 
     * Get the 'OfferItemID' element value. Carrier assigned ID which exists uniquely within an Offer.
     * 
     * @return value
     */
    public String getOfferItemID() {
        return offerItemID;
    }

    /** 
     * Set the 'OfferItemID' element value. Carrier assigned ID which exists uniquely within an Offer.
     * 
     * @param offerItemID
     */
    public void setOfferItemID(String offerItemID) {
        this.offerItemID = offerItemID;
    }

    /** 
     * Get the list of 'OrderItemRefID' element items. If provided, indicates the specified Order Item ID is proposed to be replaced with the Offer Item specified.
     * 
     * @return list
     */
    public List<String> getOrderItemRefIDList() {
        return orderItemRefIDList;
    }

    /** 
     * Set the list of 'OrderItemRefID' element items. If provided, indicates the specified Order Item ID is proposed to be replaced with the Offer Item specified.
     * 
     * @param list
     */
    public void setOrderItemRefIDList(List<String> list) {
        orderItemRefIDList = list;
    }

    /** 
     * Get the 'OriginalOrderItemDifferential' element value. Contains the Original Order amount, new Offer amount, penalty details, fees and due by details. It also contains tax information.
     * 
     * @return value
     */
    public ReshopDifferentialType getOriginalOrderItemDifferential() {
        return originalOrderItemDifferential;
    }

    /** 
     * Set the 'OriginalOrderItemDifferential' element value. Contains the Original Order amount, new Offer amount, penalty details, fees and due by details. It also contains tax information.
     * 
     * @param originalOrderItemDifferential
     */
    public void setOriginalOrderItemDifferential(
            ReshopDifferentialType originalOrderItemDifferential) {
        this.originalOrderItemDifferential = originalOrderItemDifferential;
    }

    /** 
     * Get the 'PaymentTimeLimit' element value. This node is used to indicate by when payment commitment must be received for confirmed Order Item in an Order.

    To indicate instant payment, the duration field should be populated with a value of 0.

    If no value is returned, then no advice has been given.
     * 
     * @return value
     */
    public PaymentTimeLimitType getPaymentTimeLimit() {
        return paymentTimeLimit;
    }

    /** 
     * Set the 'PaymentTimeLimit' element value. This node is used to indicate by when payment commitment must be received for confirmed Order Item in an Order.

    To indicate instant payment, the duration field should be populated with a value of 0.

    If no value is returned, then no advice has been given.
     * 
     * @param paymentTimeLimit
     */
    public void setPaymentTimeLimit(PaymentTimeLimitType paymentTimeLimit) {
        this.paymentTimeLimit = paymentTimeLimit;
    }

    /** 
     * Get the 'PenaltyDifferential' element value. Contains the Original Order amount, new Offer amount, penalty details, fees and due by details. It also contains tax information.
     * 
     * @return value
     */
    public ReshopDifferentialType getPenaltyDifferential() {
        return penaltyDifferential;
    }

    /** 
     * Set the 'PenaltyDifferential' element value. Contains the Original Order amount, new Offer amount, penalty details, fees and due by details. It also contains tax information.
     * 
     * @param penaltyDifferential
     */
    public void setPenaltyDifferential(
            ReshopDifferentialType penaltyDifferential) {
        this.penaltyDifferential = penaltyDifferential;
    }

    /** 
     * Get the 'Price' element value. The amount of money expected, required, or given in payment for something.
     * 
     * @return value
     */
    public PriceType getPrice() {
        return price;
    }

    /** 
     * Set the 'Price' element value. The amount of money expected, required, or given in payment for something.
     * 
     * @param price
     */
    public void setPrice(PriceType price) {
        this.price = price;
    }

    /** 
     * Get the 'PriceGuaranteeTimeLimitDateTime' element value. The length of time the price of an offer item is guaranteed.  In the absence of the price guarantee time limit, the price is not guaranteed.  Upon expiry, the price may no longer be guaranteed and either a new shopping process should begin, or the offer should be repriced resulting in a new Offer.    Should the price guarantee time limit extend beyond Order creation (or change), the remaining length of time persists into the corresponding Order Item.  At Order creation (or change) the airline can increase the remaining length of time beyond the original time limit should they wish to.  Note: Where a price guarantee time limit is applied, there is no guarantee that related inventory is guaranteed by the airline.
     * 
     * @return value
     */
    public DateTimeType getPriceGuaranteeTimeLimitDateTime() {
        return priceGuaranteeTimeLimitDateTime;
    }

    /** 
     * Set the 'PriceGuaranteeTimeLimitDateTime' element value. The length of time the price of an offer item is guaranteed.  In the absence of the price guarantee time limit, the price is not guaranteed.  Upon expiry, the price may no longer be guaranteed and either a new shopping process should begin, or the offer should be repriced resulting in a new Offer.    Should the price guarantee time limit extend beyond Order creation (or change), the remaining length of time persists into the corresponding Order Item.  At Order creation (or change) the airline can increase the remaining length of time beyond the original time limit should they wish to.  Note: Where a price guarantee time limit is applied, there is no guarantee that related inventory is guaranteed by the airline.
     * 
     * @param priceGuaranteeTimeLimitDateTime
     */
    public void setPriceGuaranteeTimeLimitDateTime(
            DateTimeType priceGuaranteeTimeLimitDateTime) {
        this.priceGuaranteeTimeLimitDateTime = priceGuaranteeTimeLimitDateTime;
    }

    /** 
     * Get the list of 'Service' element items. The instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order.
     * 
     * @return list
     */
    public List<ServiceType> getServiceList() {
        return serviceList;
    }

    /** 
     * Set the list of 'Service' element items. The instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order.
     * 
     * @param list
     */
    public void setServiceList(List<ServiceType> list) {
        serviceList = list;
    }
}
