
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A proposal to sell a specific set of products or Services under specific conditions, for a certain price. Can be the response to a shopping request.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:OfferItemType" name="AddOfferItem" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="BaggageDisclosureRefID" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:DeleteOrderItemType" name="DeleteOrderItem" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:DescType" name="Desc" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="DisclosureRefID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:JourneyOverviewType" name="JourneyOverview" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="MatchAppText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PercentType" name="MatchPercent" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:MatchTypeCodeContentType" name="MatchTypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:NameChangeOfferItemType" name="NameChangeOfferItem" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateTimeType" name="OfferExpirationTimeLimitDateTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OfferID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OwnerCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OwnerTypeCodeContentType" name="OwnerTypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PenaltyRefID" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PTC_OfferParametersType" name="PTC_OfferParameters" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:boolean" name="RedemptionInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="RequestedDateInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PriceType" name="TotalPrice" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ValidatingCarrierCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="WebAddressURL" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OfferType implements Serializable
{
    private List<OfferItemType> addOfferItemList = new ArrayList<OfferItemType>();
    private List<String> baggageDisclosureRefIDList = new ArrayList<String>();
    private List<DeleteOrderItemType> deleteOrderItemList = new ArrayList<DeleteOrderItemType>();
    private List<DescType> descList = new ArrayList<DescType>();
    private String disclosureRefID;
    private JourneyOverviewType journeyOverview;
    private String matchAppText;
    private PercentType matchPercent;
    private MatchTypeCodeContentType matchTypeCode;
    private NameChangeOfferItemType nameChangeOfferItem;
    private DateTimeType offerExpirationTimeLimitDateTime;
    private String offerID;
    private String ownerCode;
    private OwnerTypeCodeContentType ownerTypeCode;
    private List<String> penaltyRefIDList = new ArrayList<String>();
    private List<PTCOfferParametersType> PTCOfferParameterList = new ArrayList<PTCOfferParametersType>();
    private Boolean redemptionInd;
    private Boolean requestedDateInd;
    private PriceType totalPrice;
    private String validatingCarrierCode;
    private String webAddressURL;

    /** 
     * Get the list of 'AddOfferItem' element items. A priced grouping of one or more services within an Offer.
     * 
     * @return list
     */
    public List<OfferItemType> getAddOfferItemList() {
        return addOfferItemList;
    }

    /** 
     * Set the list of 'AddOfferItem' element items. A priced grouping of one or more services within an Offer.
     * 
     * @param list
     */
    public void setAddOfferItemList(List<OfferItemType> list) {
        addOfferItemList = list;
    }

    /** 
     * Get the list of 'BaggageDisclosureRefID' element items. Reference to a Bag Disclosure ID within this message.
     * 
     * @return list
     */
    public List<String> getBaggageDisclosureRefIDList() {
        return baggageDisclosureRefIDList;
    }

    /** 
     * Set the list of 'BaggageDisclosureRefID' element items. Reference to a Bag Disclosure ID within this message.
     * 
     * @param list
     */
    public void setBaggageDisclosureRefIDList(List<String> list) {
        baggageDisclosureRefIDList = list;
    }

    /** 
     * Get the list of 'DeleteOrderItem' element items. OrderItems which the Airline confirms can be deleted in a subsequent OrderChangeRQ. Optionally, a price differential (e.g. refund amounts) can be added to each OrderItem occurrence being deleted.  Should not be used for 'replace' type functions. In the
     * 
     * @return list
     */
    public List<DeleteOrderItemType> getDeleteOrderItemList() {
        return deleteOrderItemList;
    }

    /** 
     * Set the list of 'DeleteOrderItem' element items. OrderItems which the Airline confirms can be deleted in a subsequent OrderChangeRQ. Optionally, a price differential (e.g. refund amounts) can be added to each OrderItem occurrence being deleted.  Should not be used for 'replace' type functions. In the
     * 
     * @param list
     */
    public void setDeleteOrderItemList(List<DeleteOrderItemType> list) {
        deleteOrderItemList = list;
    }

    /** 
     * Get the list of 'Desc' element items. An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * 
     * @return list
     */
    public List<DescType> getDescList() {
        return descList;
    }

    /** 
     * Set the list of 'Desc' element items. An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * 
     * @param list
     */
    public void setDescList(List<DescType> list) {
        descList = list;
    }

    /** 
     * Get the 'DisclosureRefID' element value. Reference to a Disclosure ID within this message.
     * 
     * @return value
     */
    public String getDisclosureRefID() {
        return disclosureRefID;
    }

    /** 
     * Set the 'DisclosureRefID' element value. Reference to a Disclosure ID within this message.
     * 
     * @param disclosureRefID
     */
    public void setDisclosureRefID(String disclosureRefID) {
        this.disclosureRefID = disclosureRefID;
    }

    /** 
     * Get the 'JourneyOverview' element value. Summary of proposed Journey information in the context of this specific Offer.
     * 
     * @return value
     */
    public JourneyOverviewType getJourneyOverview() {
        return journeyOverview;
    }

    /** 
     * Set the 'JourneyOverview' element value. Summary of proposed Journey information in the context of this specific Offer.
     * 
     * @param journeyOverview
     */
    public void setJourneyOverview(JourneyOverviewType journeyOverview) {
        this.journeyOverview = journeyOverview;
    }

    /** 
     * Get the 'MatchAppText' element value. Specifies which type of flight request the match information relate to (examples: Attribute, Affinity, Other).
     * 
     * @return value
     */
    public String getMatchAppText() {
        return matchAppText;
    }

    /** 
     * Set the 'MatchAppText' element value. Specifies which type of flight request the match information relate to (examples: Attribute, Affinity, Other).
     * 
     * @param matchAppText
     */
    public void setMatchAppText(String matchAppText) {
        this.matchAppText = matchAppText;
    }

    /** 
     * Get the 'MatchPercent' element value. Offer match percentage to shopping criteria type.  This information should be populated when there is a partial match of the initial shopping criteria. Example: 60
     * 
     * @return value
     */
    public PercentType getMatchPercent() {
        return matchPercent;
    }

    /** 
     * Set the 'MatchPercent' element value. Offer match percentage to shopping criteria type.  This information should be populated when there is a partial match of the initial shopping criteria. Example: 60
     * 
     * @param matchPercent
     */
    public void setMatchPercent(PercentType matchPercent) {
        this.matchPercent = matchPercent;
    }

    /** 
     * Get the 'MatchTypeCode' element value. Offer match to shopping criteria type.  Examples: Full, None, Partial, Other Note: An additional percentage qualifier, such as 50%, may be specified for a Partial match.
     * 
     * @return value
     */
    public MatchTypeCodeContentType getMatchTypeCode() {
        return matchTypeCode;
    }

    /** 
     * Set the 'MatchTypeCode' element value. Offer match to shopping criteria type.  Examples: Full, None, Partial, Other Note: An additional percentage qualifier, such as 50%, may be specified for a Partial match.
     * 
     * @param matchTypeCode
     */
    public void setMatchTypeCode(MatchTypeCodeContentType matchTypeCode) {
        this.matchTypeCode = matchTypeCode;
    }

    /** 
     * Get the 'NameChangeOfferItem' element value. A priced grouping of one or more services within an Offer.
     * 
     * @return value
     */
    public NameChangeOfferItemType getNameChangeOfferItem() {
        return nameChangeOfferItem;
    }

    /** 
     * Set the 'NameChangeOfferItem' element value. A priced grouping of one or more services within an Offer.
     * 
     * @param nameChangeOfferItem
     */
    public void setNameChangeOfferItem(
            NameChangeOfferItemType nameChangeOfferItem) {
        this.nameChangeOfferItem = nameChangeOfferItem;
    }

    /** 
     * Get the 'OfferExpirationTimeLimitDateTime' element value. The length of time an offer will persist in an airlineâ€™s offer management system for use in subsequent transactions.  Upon expiry, the expectation is that the offer is no longer retrievable and the shopping process must begin again. Note the presence of an Offer Time Limit does not indicate either a guarantee of price or inventory against a given Offer item within the Offer.  Should the offer time limit expire, any other time limit also expires unless an Order has been created or changed.
     * 
     * @return value
     */
    public DateTimeType getOfferExpirationTimeLimitDateTime() {
        return offerExpirationTimeLimitDateTime;
    }

    /** 
     * Set the 'OfferExpirationTimeLimitDateTime' element value. The length of time an offer will persist in an airlineâ€™s offer management system for use in subsequent transactions.  Upon expiry, the expectation is that the offer is no longer retrievable and the shopping process must begin again. Note the presence of an Offer Time Limit does not indicate either a guarantee of price or inventory against a given Offer item within the Offer.  Should the offer time limit expire, any other time limit also expires unless an Order has been created or changed.
     * 
     * @param offerExpirationTimeLimitDateTime
     */
    public void setOfferExpirationTimeLimitDateTime(
            DateTimeType offerExpirationTimeLimitDateTime) {
        this.offerExpirationTimeLimitDateTime = offerExpirationTimeLimitDateTime;
    }

    /** 
     * Get the 'OfferID' element value. Carrier assigned ID which uniquely identifies a specific Offer across several messages.
     * 
     * @return value
     */
    public String getOfferID() {
        return offerID;
    }

    /** 
     * Set the 'OfferID' element value. Carrier assigned ID which uniquely identifies a specific Offer across several messages.
     * 
     * @param offerID
     */
    public void setOfferID(String offerID) {
        this.offerID = offerID;
    }

    /** 
     * Get the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @return value
     */
    public String getOwnerCode() {
        return ownerCode;
    }

    /** 
     * Set the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @param ownerCode
     */
    public void setOwnerCode(String ownerCode) {
        this.ownerCode = ownerCode;
    }

    /** 
     * Get the 'OwnerTypeCode' element value. Indicates whether or not the owner of this Offer is the ORA or POA.
     * 
     * @return value
     */
    public OwnerTypeCodeContentType getOwnerTypeCode() {
        return ownerTypeCode;
    }

    /** 
     * Set the 'OwnerTypeCode' element value. Indicates whether or not the owner of this Offer is the ORA or POA.
     * 
     * @param ownerTypeCode
     */
    public void setOwnerTypeCode(OwnerTypeCodeContentType ownerTypeCode) {
        this.ownerTypeCode = ownerTypeCode;
    }

    /** 
     * Get the list of 'PenaltyRefID' element items. Reference to a Penalty ID.
     * 
     * @return list
     */
    public List<String> getPenaltyRefIDList() {
        return penaltyRefIDList;
    }

    /** 
     * Set the list of 'PenaltyRefID' element items. Reference to a Penalty ID.
     * 
     * @param list
     */
    public void setPenaltyRefIDList(List<String> list) {
        penaltyRefIDList = list;
    }

    /** 
     * Get the list of 'PTC_OfferParameters' element items. Passenger Type summary information for an offer.
     * 
     * @return list
     */
    public List<PTCOfferParametersType> getPTCOfferParameterList() {
        return PTCOfferParameterList;
    }

    /** 
     * Set the list of 'PTC_OfferParameters' element items. Passenger Type summary information for an offer.
     * 
     * @param list
     */
    public void setPTCOfferParameterList(List<PTCOfferParametersType> list) {
        PTCOfferParameterList = list;
    }

    /** 
     * Get the 'RedemptionInd' element value. When TRUE, this Offer must be redeemed, e.g. it cannot be purchased. Note: Taxes may still apply.
     * 
     * @return value
     */
    public Boolean getRedemptionInd() {
        return redemptionInd;
    }

    /** 
     * Set the 'RedemptionInd' element value. When TRUE, this Offer must be redeemed, e.g. it cannot be purchased. Note: Taxes may still apply.
     * 
     * @param redemptionInd
     */
    public void setRedemptionInd(Boolean redemptionInd) {
        this.redemptionInd = redemptionInd;
    }

    /** 
     * Get the 'RequestedDateInd' element value. Indicator to specify if the offer relates to a requested date. For example in calendar search, this indicator will be set to 'true' if this airline offer is for a requested date and will not be present (or will be set to 'false' if airline offer is for another date than requested one.
     * 
     * @return value
     */
    public Boolean getRequestedDateInd() {
        return requestedDateInd;
    }

    /** 
     * Set the 'RequestedDateInd' element value. Indicator to specify if the offer relates to a requested date. For example in calendar search, this indicator will be set to 'true' if this airline offer is for a requested date and will not be present (or will be set to 'false' if airline offer is for another date than requested one.
     * 
     * @param requestedDateInd
     */
    public void setRequestedDateInd(Boolean requestedDateInd) {
        this.requestedDateInd = requestedDateInd;
    }

    /** 
     * Get the 'TotalPrice' element value. The amount of money expected, required, or given in payment for something.
     * 
     * @return value
     */
    public PriceType getTotalPrice() {
        return totalPrice;
    }

    /** 
     * Set the 'TotalPrice' element value. The amount of money expected, required, or given in payment for something.
     * 
     * @param totalPrice
     */
    public void setTotalPrice(PriceType totalPrice) {
        this.totalPrice = totalPrice;
    }

    /** 
     * Get the 'ValidatingCarrierCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @return value
     */
    public String getValidatingCarrierCode() {
        return validatingCarrierCode;
    }

    /** 
     * Set the 'ValidatingCarrierCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @param validatingCarrierCode
     */
    public void setValidatingCarrierCode(String validatingCarrierCode) {
        this.validatingCarrierCode = validatingCarrierCode;
    }

    /** 
     * Get the 'WebAddressURL' element value. Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer.
     * 
     * @return value
     */
    public String getWebAddressURL() {
        return webAddressURL;
    }

    /** 
     * Set the 'WebAddressURL' element value. Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer.
     * 
     * @param webAddressURL
     */
    public void setWebAddressURL(String webAddressURL) {
        this.webAddressURL = webAddressURL;
    }
}
