
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Original Order Item price which was repriced.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginalOrderItemType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:FareDetailType" name="FareDetail" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="OrderItemRefID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PriceType" name="TotalPrice" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OriginalOrderItemType implements Serializable
{
    private List<FareDetailType> fareDetailList = new ArrayList<FareDetailType>();
    private String orderItemRefID;
    private PriceType totalPrice;

    /** 
     * Get the list of 'FareDetail' element items. The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * 
     * @return list
     */
    public List<FareDetailType> getFareDetailList() {
        return fareDetailList;
    }

    /** 
     * Set the list of 'FareDetail' element items. The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * 
     * @param list
     */
    public void setFareDetailList(List<FareDetailType> list) {
        fareDetailList = list;
    }

    /** 
     * Get the 'OrderItemRefID' element value.
     * 
     * @return value
     */
    public String getOrderItemRefID() {
        return orderItemRefID;
    }

    /** 
     * Set the 'OrderItemRefID' element value.
     * 
     * @param orderItemRefID
     */
    public void setOrderItemRefID(String orderItemRefID) {
        this.orderItemRefID = orderItemRefID;
    }

    /** 
     * Get the 'TotalPrice' element value. The amount of money expected, required, or given in payment for something.
     * 
     * @return value
     */
    public PriceType getTotalPrice() {
        return totalPrice;
    }

    /** 
     * Set the 'TotalPrice' element value. The amount of money expected, required, or given in payment for something.
     * 
     * @param totalPrice
     */
    public void setTotalPrice(PriceType totalPrice) {
        this.totalPrice = totalPrice;
    }
}
