
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;

/** 
 * Other Contact Method information. E.g. web site URL, social media handle.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherAddressType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="LabelText" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OtherAddressText" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OtherAddressType implements Serializable
{
    private String labelText;
    private String otherAddressText;

    /** 
     * Get the 'LabelText' element value. Used to differentiate multiple Other Addresses of one contact.  (i.e. social media handle, website, etc.)
     * 
     * @return value
     */
    public String getLabelText() {
        return labelText;
    }

    /** 
     * Set the 'LabelText' element value. Used to differentiate multiple Other Addresses of one contact.  (i.e. social media handle, website, etc.)
     * 
     * @param labelText
     */
    public void setLabelText(String labelText) {
        this.labelText = labelText;
    }

    /** 
     * Get the 'OtherAddressText' element value. Other Contact Method Value. Example: www.marketingsite.com
     * 
     * @return value
     */
    public String getOtherAddressText() {
        return otherAddressText;
    }

    /** 
     * Set the 'OtherAddressText' element value. Other Contact Method Value. Example: www.marketingsite.com
     * 
     * @param otherAddressText
     */
    public void setOtherAddressText(String otherAddressText) {
        this.otherAddressText = otherAddressText;
    }
}
