
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Transportation of a passenger on a Dated Operating Segment.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaxSegmentType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:boolean" name="ARNK_Ind" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:TransportArrivalType" name="Arrival" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CabinTypeType" name="CabinType" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DatedOperatingLegType" name="DatedOperatingLeg" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:TransportDepType" name="Dep" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="Duration" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:InterlineSettlementInfoType" name="InterlineSettlementInfo" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DatedMarketingSegmentType" name="MarketingCarrierInfo" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DatedOperatingSegmentType" name="OperatingCarrierInfo" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PaxSegmentID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="SecureFlightInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="SegmentTypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="TicketlessInd" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaxSegmentType implements Serializable
{
    private Boolean ARNKInd;
    private TransportArrivalType arrival;
    private CabinTypeType cabinType;
    private List<DatedOperatingLegType> datedOperatingLegList = new ArrayList<DatedOperatingLegType>();
    private TransportDepType dep;
    private String duration;
    private InterlineSettlementInfoType interlineSettlementInfo;
    private DatedMarketingSegmentType marketingCarrierInfo;
    private DatedOperatingSegmentType operatingCarrierInfo;
    private String paxSegmentID;
    private Boolean secureFlightInd;
    private String segmentTypeCode;
    private Boolean ticketlessInd;

    /** 
     * Get the 'ARNK_Ind' element value. When TRUE, indicates an ARNK (ARrival uNKown) condition, i.e. a gap between current segment departure and previous segment arrival location, implying an unknown passenger movement.
     * 
     * @return value
     */
    public Boolean getARNKInd() {
        return ARNKInd;
    }

    /** 
     * Set the 'ARNK_Ind' element value. When TRUE, indicates an ARNK (ARrival uNKown) condition, i.e. a gap between current segment departure and previous segment arrival location, implying an unknown passenger movement.
     * 
     * @param ARNKInd
     */
    public void setARNKInd(Boolean ARNKInd) {
        this.ARNKInd = ARNKInd;
    }

    /** 
     * Get the 'Arrival' element value. The action or process of arriving of a transport vehicle in any place or location.
     * 
     * @return value
     */
    public TransportArrivalType getArrival() {
        return arrival;
    }

    /** 
     * Set the 'Arrival' element value. The action or process of arriving of a transport vehicle in any place or location.
     * 
     * @param arrival
     */
    public void setArrival(TransportArrivalType arrival) {
        this.arrival = arrival;
    }

    /** 
     * Get the 'CabinType' element value. Type of compartment of an aircraft, offering specific services (e.g. business class, economy).
     * 
     * @return value
     */
    public CabinTypeType getCabinType() {
        return cabinType;
    }

    /** 
     * Set the 'CabinType' element value. Type of compartment of an aircraft, offering specific services (e.g. business class, economy).
     * 
     * @param cabinType
     */
    public void setCabinType(CabinTypeType cabinType) {
        this.cabinType = cabinType;
    }

    /** 
     * Get the list of 'DatedOperatingLeg' element items. The nonstop operation of a transport vehicle between the departure station and the arrival station. Can be used for aircrafts as well as other transport vehicles such as train or bus etc.
     * 
     * @return list
     */
    public List<DatedOperatingLegType> getDatedOperatingLegList() {
        return datedOperatingLegList;
    }

    /** 
     * Set the list of 'DatedOperatingLeg' element items. The nonstop operation of a transport vehicle between the departure station and the arrival station. Can be used for aircrafts as well as other transport vehicles such as train or bus etc.
     * 
     * @param list
     */
    public void setDatedOperatingLegList(List<DatedOperatingLegType> list) {
        datedOperatingLegList = list;
    }

    /** 
     * Get the 'Dep' element value. The action or process of leaving of a transport vehicle from any place or location.
     * 
     * @return value
     */
    public TransportDepType getDep() {
        return dep;
    }

    /** 
     * Set the 'Dep' element value. The action or process of leaving of a transport vehicle from any place or location.
     * 
     * @param dep
     */
    public void setDep(TransportDepType dep) {
        this.dep = dep;
    }

    /** 
     * Get the 'Duration' element value. Total segment time including the combined air time and connection times of any legs.
     * 
     * @return value
     */
    public String getDuration() {
        return duration;
    }

    /** 
     * Set the 'Duration' element value. Total segment time including the combined air time and connection times of any legs.
     * 
     * @param duration
     */
    public void setDuration(String duration) {
        this.duration = duration;
    }

    /** 
     * Get the 'InterlineSettlementInfo' element value. Information related to the value of a product or service as it pertains to interline transactions.
     * 
     * @return value
     */
    public InterlineSettlementInfoType getInterlineSettlementInfo() {
        return interlineSettlementInfo;
    }

    /** 
     * Set the 'InterlineSettlementInfo' element value. Information related to the value of a product or service as it pertains to interline transactions.
     * 
     * @param interlineSettlementInfo
     */
    public void setInterlineSettlementInfo(
            InterlineSettlementInfoType interlineSettlementInfo) {
        this.interlineSettlementInfo = interlineSettlementInfo;
    }

    /** 
     * Get the 'MarketingCarrierInfo' element value. The commercial designation under which a Dated Operating Segment can be booked, either under the operating carrier's designator or that of another carrier (codeshare).
     * 
     * @return value
     */
    public DatedMarketingSegmentType getMarketingCarrierInfo() {
        return marketingCarrierInfo;
    }

    /** 
     * Set the 'MarketingCarrierInfo' element value. The commercial designation under which a Dated Operating Segment can be booked, either under the operating carrier's designator or that of another carrier (codeshare).
     * 
     * @param marketingCarrierInfo
     */
    public void setMarketingCarrierInfo(
            DatedMarketingSegmentType marketingCarrierInfo) {
        this.marketingCarrierInfo = marketingCarrierInfo;
    }

    /** 
     * Get the 'OperatingCarrierInfo' element value. An operation between board point and any subsequent off point within the same flight designator. Could be one or more legs. Could also be used for other transport vehicles such as train or bus etc.
     * 
     * @return value
     */
    public DatedOperatingSegmentType getOperatingCarrierInfo() {
        return operatingCarrierInfo;
    }

    /** 
     * Set the 'OperatingCarrierInfo' element value. An operation between board point and any subsequent off point within the same flight designator. Could be one or more legs. Could also be used for other transport vehicles such as train or bus etc.
     * 
     * @param operatingCarrierInfo
     */
    public void setOperatingCarrierInfo(
            DatedOperatingSegmentType operatingCarrierInfo) {
        this.operatingCarrierInfo = operatingCarrierInfo;
    }

    /** 
     * Get the 'PaxSegmentID' element value. Uniquely identifies a Passenger Segment within the context of one message.
     * 
     * @return value
     */
    public String getPaxSegmentID() {
        return paxSegmentID;
    }

    /** 
     * Set the 'PaxSegmentID' element value. Uniquely identifies a Passenger Segment within the context of one message.
     * 
     * @param paxSegmentID
     */
    public void setPaxSegmentID(String paxSegmentID) {
        this.paxSegmentID = paxSegmentID;
    }

    /** 
     * Get the 'SecureFlightInd' element value. When TRUE, this segment is subject to US TSA 'Secure Flight' passenger prescreening program.
     * 
     * @return value
     */
    public Boolean getSecureFlightInd() {
        return secureFlightInd;
    }

    /** 
     * Set the 'SecureFlightInd' element value. When TRUE, this segment is subject to US TSA 'Secure Flight' passenger prescreening program.
     * 
     * @param secureFlightInd
     */
    public void setSecureFlightInd(Boolean secureFlightInd) {
        this.secureFlightInd = secureFlightInd;
    }

    /** 
     * Get the 'SegmentTypeCode' element value. Defines the operational flight segment type (e.g. Open, Passive, Service).  Encoding Scheme: IATA PADIS 1.4 Codeset FST - Flight Segment Type
     * 
     * @return value
     */
    public String getSegmentTypeCode() {
        return segmentTypeCode;
    }

    /** 
     * Set the 'SegmentTypeCode' element value. Defines the operational flight segment type (e.g. Open, Passive, Service).  Encoding Scheme: IATA PADIS 1.4 Codeset FST - Flight Segment Type
     * 
     * @param segmentTypeCode
     */
    public void setSegmentTypeCode(String segmentTypeCode) {
        this.segmentTypeCode = segmentTypeCode;
    }

    /** 
     * Get the 'TicketlessInd' element value. When TRUE, there are no ticket records, as defined by IATA Resolutions, expected to be issued for this segment.
     * 
     * @return value
     */
    public Boolean getTicketlessInd() {
        return ticketlessInd;
    }

    /** 
     * Set the 'TicketlessInd' element value. When TRUE, there are no ticket records, as defined by IATA Resolutions, expected to be issued for this segment.
     * 
     * @param ticketlessInd
     */
    public void setTicketlessInd(Boolean ticketlessInd) {
        this.ticketlessInd = ticketlessInd;
    }
}
