
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Information related to the settlement of a transaction through monetary or other compensations. For example, a payment may be applied to an entire Order or individual Order Items.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AmountType" name="Amount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ContactInfoRefID" minOccurs="0"/>
 *     &lt;xs:element type="ns:DescType" name="Desc" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PaymentInfoID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaymentMethodType" name="PaymentMethod" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PaymentRefID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaymentStatusCodeContentType" name="PaymentStatusCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:AmountType" name="PriceVarianceAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PriceVarianceRuleType" name="PriceVarianceRule" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PromotionType" name="Promotion" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:AmountType" name="SurchargeAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="VerificationInd" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaymentInfoType implements Serializable
{
    private AmountType amount;
    private String contactInfoRefID;
    private DescType desc;
    private String paymentInfoID;
    private PaymentMethodType paymentMethod;
    private String paymentRefID;
    private PaymentStatusCodeContentType paymentStatusCode;
    private AmountType priceVarianceAmount;
    private PriceVarianceRuleType priceVarianceRule;
    private List<PromotionType> promotionList = new ArrayList<PromotionType>();
    private AmountType surchargeAmount;
    private String typeCode;
    private Boolean verificationInd;

    /** 
     * Get the 'Amount' element value. The amount applied to the associated payment method.  Example: 300 USD
     * 
     * @return value
     */
    public AmountType getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. The amount applied to the associated payment method.  Example: 300 USD
     * 
     * @param amount
     */
    public void setAmount(AmountType amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'ContactInfoRefID' element value. Reference to the Payer's ContactInfoID.
     * 
     * @return value
     */
    public String getContactInfoRefID() {
        return contactInfoRefID;
    }

    /** 
     * Set the 'ContactInfoRefID' element value. Reference to the Payer's ContactInfoID.
     * 
     * @param contactInfoRefID
     */
    public void setContactInfoRefID(String contactInfoRefID) {
        this.contactInfoRefID = contactInfoRefID;
    }

    /** 
     * Get the 'Desc' element value. An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * 
     * @return value
     */
    public DescType getDesc() {
        return desc;
    }

    /** 
     * Set the 'Desc' element value. An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * 
     * @param desc
     */
    public void setDesc(DescType desc) {
        this.desc = desc;
    }

    /** 
     * Get the 'PaymentInfoID' element value. Uniquely identifies payment information within a message.
     * 
     * @return value
     */
    public String getPaymentInfoID() {
        return paymentInfoID;
    }

    /** 
     * Set the 'PaymentInfoID' element value. Uniquely identifies payment information within a message.
     * 
     * @param paymentInfoID
     */
    public void setPaymentInfoID(String paymentInfoID) {
        this.paymentInfoID = paymentInfoID;
    }

    /** 
     * Get the 'PaymentMethod' element value. A form of procedure for the payment of goods or services, plus any transactional information specific to the payment method other than the amount.
     * 
     * @return value
     */
    public PaymentMethodType getPaymentMethod() {
        return paymentMethod;
    }

    /** 
     * Set the 'PaymentMethod' element value. A form of procedure for the payment of goods or services, plus any transactional information specific to the payment method other than the amount.
     * 
     * @param paymentMethod
     */
    public void setPaymentMethod(PaymentMethodType paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    /** 
     * Get the 'PaymentRefID' element value. If creating the order after payment authorization it is a way of linking an order to an existing payment reference. not triggering the whole process again.
     * 
     * @return value
     */
    public String getPaymentRefID() {
        return paymentRefID;
    }

    /** 
     * Set the 'PaymentRefID' element value. If creating the order after payment authorization it is a way of linking an order to an existing payment reference. not triggering the whole process again.
     * 
     * @param paymentRefID
     */
    public void setPaymentRefID(String paymentRefID) {
        this.paymentRefID = paymentRefID;
    }

    /** 
     * Get the 'PaymentStatusCode' element value. Indicates the current status of this payment information.
     * 
     * @return value
     */
    public PaymentStatusCodeContentType getPaymentStatusCode() {
        return paymentStatusCode;
    }

    /** 
     * Set the 'PaymentStatusCode' element value. Indicates the current status of this payment information.
     * 
     * @param paymentStatusCode
     */
    public void setPaymentStatusCode(
            PaymentStatusCodeContentType paymentStatusCode) {
        this.paymentStatusCode = paymentStatusCode;
    }

    /** 
     * Get the 'PriceVarianceAmount' element value. Price variance amount applied during Payment processing.
     * 
     * @return value
     */
    public AmountType getPriceVarianceAmount() {
        return priceVarianceAmount;
    }

    /** 
     * Set the 'PriceVarianceAmount' element value. Price variance amount applied during Payment processing.
     * 
     * @param priceVarianceAmount
     */
    public void setPriceVarianceAmount(AmountType priceVarianceAmount) {
        this.priceVarianceAmount = priceVarianceAmount;
    }

    /** 
     * Get the 'PriceVarianceRule' element value. Price Variance supports specifying Payment Processing Rules, including payment failure. Acceptable amount and/or percentage of the total amount by which the Order item price can vary. Example: 20 USD, 2 Percent
     * 
     * @return value
     */
    public PriceVarianceRuleType getPriceVarianceRule() {
        return priceVarianceRule;
    }

    /** 
     * Set the 'PriceVarianceRule' element value. Price Variance supports specifying Payment Processing Rules, including payment failure. Acceptable amount and/or percentage of the total amount by which the Order item price can vary. Example: 20 USD, 2 Percent
     * 
     * @param priceVarianceRule
     */
    public void setPriceVarianceRule(PriceVarianceRuleType priceVarianceRule) {
        this.priceVarianceRule = priceVarianceRule;
    }

    /** 
     * Get the list of 'Promotion' element items. Information related to publicizing  a product, organization, or venture so as to increase sales or public awareness.
     * 
     * @return list
     */
    public List<PromotionType> getPromotionList() {
        return promotionList;
    }

    /** 
     * Set the list of 'Promotion' element items. Information related to publicizing  a product, organization, or venture so as to increase sales or public awareness.
     * 
     * @param list
     */
    public void setPromotionList(List<PromotionType> list) {
        promotionList = list;
    }

    /** 
     * Get the 'SurchargeAmount' element value. Amount added to the final Offer/Order price, depending on which payment method is used by the client.
     * 
     * @return value
     */
    public AmountType getSurchargeAmount() {
        return surchargeAmount;
    }

    /** 
     * Set the 'SurchargeAmount' element value. Amount added to the final Offer/Order price, depending on which payment method is used by the client.
     * 
     * @param surchargeAmount
     */
    public void setSurchargeAmount(AmountType surchargeAmount) {
        this.surchargeAmount = surchargeAmount;
    }

    /** 
     * Get the 'TypeCode' element value. The payment method type. Examples: Credit Card, Cash.
     * 
     * @return value
     */
    public String getTypeCode() {
        return typeCode;
    }

    /** 
     * Set the 'TypeCode' element value. The payment method type. Examples: Credit Card, Cash.
     * 
     * @param typeCode
     */
    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    /** 
     * Get the 'VerificationInd' element value. When true, this payment requires additional authentication.
     * 
     * @return value
     */
    public Boolean getVerificationInd() {
        return verificationInd;
    }

    /** 
     * Set the 'VerificationInd' element value. When true, this payment requires additional authentication.
     * 
     * @param verificationInd
     */
    public void setVerificationInd(Boolean verificationInd) {
        this.verificationInd = verificationInd;
    }
}
