
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;

/** 
 * This node is used to indicate by when payment commitment must be received for confirmed Order Item in an Order.  To indicate instant payment, the duration field should be populated with a value of 0.  If no value is returned, then no advice has been given.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentTimeLimitType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:DateTimeType" name="PaymentTimeLimitDateTime" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PaymentTimeLimitDuration" maxOccurs="1"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaymentTimeLimitType implements Serializable
{
    private int choiceSelect = -1;
    private static final int PAYMENT_TIME_LIMIT_DATE_TIME_CHOICE = 0;
    private static final int PAYMENT_TIME_LIMIT_DURATION_CHOICE = 1;
    private DateTimeType paymentTimeLimitDateTime;
    private String paymentTimeLimitDuration;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if PaymentTimeLimitDateTime is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPaymentTimeLimitDateTime() {
        return choiceSelect == PAYMENT_TIME_LIMIT_DATE_TIME_CHOICE;
    }

    /** 
     * Get the 'PaymentTimeLimitDateTime' element value. A date/time by which payment commitment is required for a given Order Item.  For example:  PaymentTimeLimitDateTime: â€œ2018-01-01T12:00:00Zâ€&#157; shows a static payment commitment date/time for a given Order Item.
     * 
     * @return value
     */
    public DateTimeType getPaymentTimeLimitDateTime() {
        return paymentTimeLimitDateTime;
    }

    /** 
     * Set the 'PaymentTimeLimitDateTime' element value. A date/time by which payment commitment is required for a given Order Item.  For example:  PaymentTimeLimitDateTime: â€œ2018-01-01T12:00:00Zâ€&#157; shows a static payment commitment date/time for a given Order Item.
     * 
     * @param paymentTimeLimitDateTime
     */
    public void setPaymentTimeLimitDateTime(
            DateTimeType paymentTimeLimitDateTime) {
        setChoiceSelect(PAYMENT_TIME_LIMIT_DATE_TIME_CHOICE);
        this.paymentTimeLimitDateTime = paymentTimeLimitDateTime;
    }

    /** 
     * Check if PaymentTimeLimitDuration is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPaymentTimeLimitDuration() {
        return choiceSelect == PAYMENT_TIME_LIMIT_DURATION_CHOICE;
    }

    /** 
     * Get the 'PaymentTimeLimitDuration' element value. Duration from the Order creation date by which payment commitment is required for a given Order Item.  For example:  PaymentTimeLimitDuration: â€œPT48H3M6Sâ€&#157; shows the amount of time after Order is created/changed that payment commitment must be made for a given Order Item. PaymentTimeLimitDuration: â€œPT0H0M0Sâ€&#157; indicates instant payment is required for a given Order Item.
     * 
     * @return value
     */
    public String getPaymentTimeLimitDuration() {
        return paymentTimeLimitDuration;
    }

    /** 
     * Set the 'PaymentTimeLimitDuration' element value. Duration from the Order creation date by which payment commitment is required for a given Order Item.  For example:  PaymentTimeLimitDuration: â€œPT48H3M6Sâ€&#157; shows the amount of time after Order is created/changed that payment commitment must be made for a given Order Item. PaymentTimeLimitDuration: â€œPT0H0M0Sâ€&#157; indicates instant payment is required for a given Order Item.
     * 
     * @param paymentTimeLimitDuration
     */
    public void setPaymentTimeLimitDuration(String paymentTimeLimitDuration) {
        setChoiceSelect(PAYMENT_TIME_LIMIT_DURATION_CHOICE);
        this.paymentTimeLimitDuration = paymentTimeLimitDuration;
    }
}
