
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Offers presented in response to a reprice request in the OrderReshopRQ. If there is a change in the price of the Order, these Offers may be subsequently accepted in the OrderChangeRQ and the repriced OrderItems (returned as OfferItems) will then replace
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RepricedOfferItemType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:FareDetailType" name="FareDetail" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="OfferItemRefID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OriginalOrderItemType" name="OriginalOrderItem" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaymentTimeLimitType" name="PaymentTimeLimit" minOccurs="0"/>
 *     &lt;xs:element type="ns:DateTimeType" name="PriceGuaranteeTimeLimitDateTime" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceType" name="TotalPrice" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RepricedOfferItemType implements Serializable
{
    private List<FareDetailType> fareDetailList = new ArrayList<FareDetailType>();
    private String offerItemRefID;
    private OriginalOrderItemType originalOrderItem;
    private PaymentTimeLimitType paymentTimeLimit;
    private DateTimeType priceGuaranteeTimeLimitDateTime;
    private PriceType totalPrice;

    /** 
     * Get the list of 'FareDetail' element items. The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * 
     * @return list
     */
    public List<FareDetailType> getFareDetailList() {
        return fareDetailList;
    }

    /** 
     * Set the list of 'FareDetail' element items. The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * 
     * @param list
     */
    public void setFareDetailList(List<FareDetailType> list) {
        fareDetailList = list;
    }

    /** 
     * Get the 'OfferItemRefID' element value. Reference to an Offer Item ID requested in the OrderReshopRQ.
     * 
     * @return value
     */
    public String getOfferItemRefID() {
        return offerItemRefID;
    }

    /** 
     * Set the 'OfferItemRefID' element value. Reference to an Offer Item ID requested in the OrderReshopRQ.
     * 
     * @param offerItemRefID
     */
    public void setOfferItemRefID(String offerItemRefID) {
        this.offerItemRefID = offerItemRefID;
    }

    /** 
     * Get the 'OriginalOrderItem' element value. Original Order Item price which was repriced.
     * 
     * @return value
     */
    public OriginalOrderItemType getOriginalOrderItem() {
        return originalOrderItem;
    }

    /** 
     * Set the 'OriginalOrderItem' element value. Original Order Item price which was repriced.
     * 
     * @param originalOrderItem
     */
    public void setOriginalOrderItem(OriginalOrderItemType originalOrderItem) {
        this.originalOrderItem = originalOrderItem;
    }

    /** 
     * Get the 'PaymentTimeLimit' element value. This node is used to indicate by when payment commitment must be received for confirmed Order Item in an Order.

    To indicate instant payment, the duration field should be populated with a value of 0.

    If no value is returned, then no advice has been given.
     * 
     * @return value
     */
    public PaymentTimeLimitType getPaymentTimeLimit() {
        return paymentTimeLimit;
    }

    /** 
     * Set the 'PaymentTimeLimit' element value. This node is used to indicate by when payment commitment must be received for confirmed Order Item in an Order.

    To indicate instant payment, the duration field should be populated with a value of 0.

    If no value is returned, then no advice has been given.
     * 
     * @param paymentTimeLimit
     */
    public void setPaymentTimeLimit(PaymentTimeLimitType paymentTimeLimit) {
        this.paymentTimeLimit = paymentTimeLimit;
    }

    /** 
     * Get the 'PriceGuaranteeTimeLimitDateTime' element value. The length of time the price of an offer item is guaranteed.  In the absence of the price guarantee time limit, the price is not guaranteed.  Upon expiry, the price may no longer be guaranteed and either a new shopping process should begin, or the offer should be repriced resulting in a new Offer.    Should the price guarantee time limit extend beyond Order creation (or change), the remaining length of time persists into the corresponding Order Item.  At Order creation (or change) the airline can increase the remaining length of time beyond the original time limit should they wish to.  Note: Where a price guarantee time limit is applied, there is no guarantee that related inventory is guaranteed by the airline.
     * 
     * @return value
     */
    public DateTimeType getPriceGuaranteeTimeLimitDateTime() {
        return priceGuaranteeTimeLimitDateTime;
    }

    /** 
     * Set the 'PriceGuaranteeTimeLimitDateTime' element value. The length of time the price of an offer item is guaranteed.  In the absence of the price guarantee time limit, the price is not guaranteed.  Upon expiry, the price may no longer be guaranteed and either a new shopping process should begin, or the offer should be repriced resulting in a new Offer.    Should the price guarantee time limit extend beyond Order creation (or change), the remaining length of time persists into the corresponding Order Item.  At Order creation (or change) the airline can increase the remaining length of time beyond the original time limit should they wish to.  Note: Where a price guarantee time limit is applied, there is no guarantee that related inventory is guaranteed by the airline.
     * 
     * @param priceGuaranteeTimeLimitDateTime
     */
    public void setPriceGuaranteeTimeLimitDateTime(
            DateTimeType priceGuaranteeTimeLimitDateTime) {
        this.priceGuaranteeTimeLimitDateTime = priceGuaranteeTimeLimitDateTime;
    }

    /** 
     * Get the 'TotalPrice' element value. The amount of money expected, required, or given in payment for something.
     * 
     * @return value
     */
    public PriceType getTotalPrice() {
        return totalPrice;
    }

    /** 
     * Set the 'TotalPrice' element value. The amount of money expected, required, or given in payment for something.
     * 
     * @param totalPrice
     */
    public void setTotalPrice(PriceType totalPrice) {
        this.totalPrice = totalPrice;
    }
}
