
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Function used to request the repricing of an existing Order, possibly as a consequence of expired TimeLimits. Airline returns Offers/OfferItems that describe the changes incurred from the reprice request.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RepricedOfferType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DateTimeType" name="OfferExpirationTimeLimitDateTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OfferRefID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OwnerCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OwnerTypeCodeContentType" name="OwnerTypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:RepricedOfferItemType" name="RepricedOfferItem" minOccurs="1" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:boolean" name="RequestedDateInd" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RepricedOfferType implements Serializable
{
    private DateTimeType offerExpirationTimeLimitDateTime;
    private String offerRefID;
    private String ownerCode;
    private OwnerTypeCodeContentType ownerTypeCode;
    private List<RepricedOfferItemType> repricedOfferItemList = new ArrayList<RepricedOfferItemType>();
    private Boolean requestedDateInd;

    /** 
     * Get the 'OfferExpirationTimeLimitDateTime' element value. The length of time an offer will persist in an airlineâ€™s offer management system for use in subsequent transactions.  Upon expiry, the expectation is that the offer is no longer retrievable and the shopping process must begin again. Note the presence of an Offer Time Limit does not indicate either a guarantee of price or inventory against a given Offer item within the Offer.  Should the offer time limit expire, any other time limit also expires unless an Order has been created or changed.
     * 
     * @return value
     */
    public DateTimeType getOfferExpirationTimeLimitDateTime() {
        return offerExpirationTimeLimitDateTime;
    }

    /** 
     * Set the 'OfferExpirationTimeLimitDateTime' element value. The length of time an offer will persist in an airlineâ€™s offer management system for use in subsequent transactions.  Upon expiry, the expectation is that the offer is no longer retrievable and the shopping process must begin again. Note the presence of an Offer Time Limit does not indicate either a guarantee of price or inventory against a given Offer item within the Offer.  Should the offer time limit expire, any other time limit also expires unless an Order has been created or changed.
     * 
     * @param offerExpirationTimeLimitDateTime
     */
    public void setOfferExpirationTimeLimitDateTime(
            DateTimeType offerExpirationTimeLimitDateTime) {
        this.offerExpirationTimeLimitDateTime = offerExpirationTimeLimitDateTime;
    }

    /** 
     * Get the 'OfferRefID' element value. Reference to an Offer ID requested in the OrderReshopRQ.
     * 
     * @return value
     */
    public String getOfferRefID() {
        return offerRefID;
    }

    /** 
     * Set the 'OfferRefID' element value. Reference to an Offer ID requested in the OrderReshopRQ.
     * 
     * @param offerRefID
     */
    public void setOfferRefID(String offerRefID) {
        this.offerRefID = offerRefID;
    }

    /** 
     * Get the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @return value
     */
    public String getOwnerCode() {
        return ownerCode;
    }

    /** 
     * Set the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @param ownerCode
     */
    public void setOwnerCode(String ownerCode) {
        this.ownerCode = ownerCode;
    }

    /** 
     * Get the 'OwnerTypeCode' element value. Indicates whether or not the owner of this Offer is the ORA or POA.
     * 
     * @return value
     */
    public OwnerTypeCodeContentType getOwnerTypeCode() {
        return ownerTypeCode;
    }

    /** 
     * Set the 'OwnerTypeCode' element value. Indicates whether or not the owner of this Offer is the ORA or POA.
     * 
     * @param ownerTypeCode
     */
    public void setOwnerTypeCode(OwnerTypeCodeContentType ownerTypeCode) {
        this.ownerTypeCode = ownerTypeCode;
    }

    /** 
     * Get the list of 'RepricedOfferItem' element items. Offers presented in response to a reprice request in the OrderReshopRQ. If there is a change in the price of the Order, these Offers may be subsequently accepted in the OrderChangeRQ and the repriced OrderItems (returned as OfferItems) will then replace
     * 
     * @return list
     */
    public List<RepricedOfferItemType> getRepricedOfferItemList() {
        return repricedOfferItemList;
    }

    /** 
     * Set the list of 'RepricedOfferItem' element items. Offers presented in response to a reprice request in the OrderReshopRQ. If there is a change in the price of the Order, these Offers may be subsequently accepted in the OrderChangeRQ and the repriced OrderItems (returned as OfferItems) will then replace
     * 
     * @param list
     */
    public void setRepricedOfferItemList(List<RepricedOfferItemType> list) {
        repricedOfferItemList = list;
    }

    /** 
     * Get the 'RequestedDateInd' element value. Indicator to specify if the offer relates to a requested date. For example in calendar search, this indicator will be set to 'true' if this airline offer is for a requested date and will not be present (or will be set to 'false' if airline offer is for another date than requested one.
     * 
     * @return value
     */
    public Boolean getRequestedDateInd() {
        return requestedDateInd;
    }

    /** 
     * Set the 'RequestedDateInd' element value. Indicator to specify if the offer relates to a requested date. For example in calendar search, this indicator will be set to 'true' if this airline offer is for a requested date and will not be present (or will be set to 'false' if airline offer is for another date than requested one.
     * 
     * @param requestedDateInd
     */
    public void setRequestedDateInd(Boolean requestedDateInd) {
        this.requestedDateInd = requestedDateInd;
    }
}
