
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;

/** 
 * Contains the Original Order amount, new Offer amount, penalty details, fees and due by details. It also contains tax information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReshopDifferentialType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AmountType" name="Amount" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:TaxSummaryType" name="TaxSummary" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ReshopDifferentialType implements Serializable
{
    private AmountType amount;
    private TaxSummaryType taxSummary;

    /** 
     * Get the 'Amount' element value.
     * 
     * @return value
     */
    public AmountType getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value.
     * 
     * @param amount
     */
    public void setAmount(AmountType amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'TaxSummary' element value. Tax summary information.
     * 
     * @return value
     */
    public TaxSummaryType getTaxSummary() {
        return taxSummary;
    }

    /** 
     * Set the 'TaxSummary' element value. Tax summary information.
     * 
     * @param taxSummary
     */
    public void setTaxSummary(TaxSummaryType taxSummary) {
        this.taxSummary = taxSummary;
    }
}
