
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:InterlineSettlementInfoType" name="InterlineSettlementInfo" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateTimeType" name="InventoryGuaranteeTimeLimitDateTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PaxRefID" minOccurs="1" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:ServiceAssociationsType" name="ServiceAssociations" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ServiceID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ServiceRefID" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceType implements Serializable
{
    private InterlineSettlementInfoType interlineSettlementInfo;
    private DateTimeType inventoryGuaranteeTimeLimitDateTime;
    private List<String> paxRefIDList = new ArrayList<String>();
    private ServiceAssociationsType serviceAssociations;
    private String serviceID;
    private String serviceRefID;

    /** 
     * Get the 'InterlineSettlementInfo' element value. Information related to the value of a product or service as it pertains to interline transactions.
     * 
     * @return value
     */
    public InterlineSettlementInfoType getInterlineSettlementInfo() {
        return interlineSettlementInfo;
    }

    /** 
     * Set the 'InterlineSettlementInfo' element value. Information related to the value of a product or service as it pertains to interline transactions.
     * 
     * @param interlineSettlementInfo
     */
    public void setInterlineSettlementInfo(
            InterlineSettlementInfoType interlineSettlementInfo) {
        this.interlineSettlementInfo = interlineSettlementInfo;
    }

    /** 
     * Get the 'InventoryGuaranteeTimeLimitDateTime' element value. The length of time inventory against a given Service is guaranteed.  If inventory is not guaranteed, the Order creation (or change) may fail. In the absence of a time limit, no inventory is guaranteed.   Notes:  The presence of an inventory guarantee does not assume a guarantee of price.  For the price to be guaranteed against a given Offer Item, the Price Guarantee Time Limit must also be present.  The assumption is that inventory is held when an Order is created (or changed), so this time limit only applies in the context of an Offer.
     * 
     * @return value
     */
    public DateTimeType getInventoryGuaranteeTimeLimitDateTime() {
        return inventoryGuaranteeTimeLimitDateTime;
    }

    /** 
     * Set the 'InventoryGuaranteeTimeLimitDateTime' element value. The length of time inventory against a given Service is guaranteed.  If inventory is not guaranteed, the Order creation (or change) may fail. In the absence of a time limit, no inventory is guaranteed.   Notes:  The presence of an inventory guarantee does not assume a guarantee of price.  For the price to be guaranteed against a given Offer Item, the Price Guarantee Time Limit must also be present.  The assumption is that inventory is held when an Order is created (or changed), so this time limit only applies in the context of an Offer.
     * 
     * @param inventoryGuaranteeTimeLimitDateTime
     */
    public void setInventoryGuaranteeTimeLimitDateTime(
            DateTimeType inventoryGuaranteeTimeLimitDateTime) {
        this.inventoryGuaranteeTimeLimitDateTime = inventoryGuaranteeTimeLimitDateTime;
    }

    /** 
     * Get the list of 'PaxRefID' element items. Reference to a Passenger ID within this message. The Passenger is the recipient entitled to receive/consume the Service(s) offered by the Airline, whether the Service(s) are flight-related or not.
     * 
     * @return list
     */
    public List<String> getPaxRefIDList() {
        return paxRefIDList;
    }

    /** 
     * Set the list of 'PaxRefID' element items. Reference to a Passenger ID within this message. The Passenger is the recipient entitled to receive/consume the Service(s) offered by the Airline, whether the Service(s) are flight-related or not.
     * 
     * @param list
     */
    public void setPaxRefIDList(List<String> list) {
        paxRefIDList = list;
    }

    /** 
     * Get the 'ServiceAssociations' element value. References to the details of this Service.  May include either Passenger Journeys, a Service Definition, or a Selected Seat.
     * 
     * @return value
     */
    public ServiceAssociationsType getServiceAssociations() {
        return serviceAssociations;
    }

    /** 
     * Set the 'ServiceAssociations' element value. References to the details of this Service.  May include either Passenger Journeys, a Service Definition, or a Selected Seat.
     * 
     * @param serviceAssociations
     */
    public void setServiceAssociations(
            ServiceAssociationsType serviceAssociations) {
        this.serviceAssociations = serviceAssociations;
    }

    /** 
     * Get the 'ServiceID' element value. Uniquely Identifies a Service within the context of one message.
     * 
     * @return value
     */
    public String getServiceID() {
        return serviceID;
    }

    /** 
     * Set the 'ServiceID' element value. Uniquely Identifies a Service within the context of one message.
     * 
     * @param serviceID
     */
    public void setServiceID(String serviceID) {
        this.serviceID = serviceID;
    }

    /** 
     * Get the 'ServiceRefID' element value. Reference to another service instance.
     * 
     * @return value
     */
    public String getServiceRefID() {
        return serviceRefID;
    }

    /** 
     * Set the 'ServiceRefID' element value. Reference to another service instance.
     * 
     * @param serviceRefID
     */
    public void setServiceRefID(String serviceRefID) {
        this.serviceRefID = serviceRefID;
    }
}
