
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;

/** 
 * Facilitates the tracking of what was Offered and contains an identifier unique to the source Airline for a set of product Offers returned in response to a shopping request.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ShoppingResponseType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ShoppingResponseRefID" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ShoppingResponseType implements Serializable
{
    private String shoppingResponseRefID;

    /** 
     * Get the 'ShoppingResponseRefID' element value. Reference to unique shopping session response ID, as provided in the airline's previous shopping response.
     * 
     * @return value
     */
    public String getShoppingResponseRefID() {
        return shoppingResponseRefID;
    }

    /** 
     * Set the 'ShoppingResponseRefID' element value. Reference to unique shopping session response ID, as provided in the airline's previous shopping response.
     * 
     * @param shoppingResponseRefID
     */
    public void setShoppingResponseRefID(String shoppingResponseRefID) {
        this.shoppingResponseRefID = shoppingResponseRefID;
    }
}
