
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Amount added on to a usual charge for a specific product, purpose, or service.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SurchargeType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:boolean" name="AllRefundableInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:FeeType" name="Breakdown" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:AmountType" name="TotalAmount" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SurchargeType implements Serializable
{
    private Boolean allRefundableInd;
    private List<FeeType> breakdownList = new ArrayList<FeeType>();
    private AmountType totalAmount;

    /** 
     * Get the 'AllRefundableInd' element value. When true, all fee/ surcharge amounts are refundable. Example: true
     * 
     * @return value
     */
    public Boolean getAllRefundableInd() {
        return allRefundableInd;
    }

    /** 
     * Set the 'AllRefundableInd' element value. When true, all fee/ surcharge amounts are refundable. Example: true
     * 
     * @param allRefundableInd
     */
    public void setAllRefundableInd(Boolean allRefundableInd) {
        this.allRefundableInd = allRefundableInd;
    }

    /** 
     * Get the list of 'Breakdown' element items. Amount added on to a charge for a specific product, purpose, or service.
     * 
     * @return list
     */
    public List<FeeType> getBreakdownList() {
        return breakdownList;
    }

    /** 
     * Set the list of 'Breakdown' element items. Amount added on to a charge for a specific product, purpose, or service.
     * 
     * @param list
     */
    public void setBreakdownList(List<FeeType> list) {
        breakdownList = list;
    }

    /** 
     * Get the 'TotalAmount' element value. Summary of all fee amounts.
     * 
     * @return value
     */
    public AmountType getTotalAmount() {
        return totalAmount;
    }

    /** 
     * Set the 'TotalAmount' element value. Summary of all fee amounts.
     * 
     * @param totalAmount
     */
    public void setTotalAmount(AmountType totalAmount) {
        this.totalAmount = totalAmount;
    }
}
