
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A compulsory contribution to state revenue, levied by the government on workers' income and business profits or added to the cost of some goods, services, and transactions.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AddlFiledTaxCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="AddlTaxCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:AmountType" name="Amount" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="ApproximateInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="AppTypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="CollectionInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CollectionPointTaxType" name="CollectionPointTax" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:CountryType" name="Country" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CountrySubDivisionType" name="CountrySubDivision" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CurConversionType" name="CurConversion" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="DescText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:AmountType" name="FiledAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="FiledTaxCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="QualifierCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="RefundInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TaxCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TaxName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:TaxTypeCodeContentType" name="TaxTypeCode" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TaxType implements Serializable
{
    private String addlFiledTaxCode;
    private String addlTaxCode;
    private AmountType amount;
    private Boolean approximateInd;
    private String appTypeCode;
    private Boolean collectionInd;
    private List<CollectionPointTaxType> collectionPointTaxList = new ArrayList<CollectionPointTaxType>();
    private CountryType country;
    private CountrySubDivisionType countrySubDivision;
    private CurConversionType curConversion;
    private String descText;
    private AmountType filedAmount;
    private String filedTaxCode;
    private String qualifierCode;
    private Boolean refundInd;
    private String taxCode;
    private String taxName;
    private TaxTypeCodeContentType taxTypeCode;

    /** 
     * Get the 'AddlFiledTaxCode' element value. A qualifier to the Tax Code to distinguish taxes/fees/charges with the same tax code but with different business uses.
     * 
     * @return value
     */
    public String getAddlFiledTaxCode() {
        return addlFiledTaxCode;
    }

    /** 
     * Set the 'AddlFiledTaxCode' element value. A qualifier to the Tax Code to distinguish taxes/fees/charges with the same tax code but with different business uses.
     * 
     * @param addlFiledTaxCode
     */
    public void setAddlFiledTaxCode(String addlFiledTaxCode) {
        this.addlFiledTaxCode = addlFiledTaxCode;
    }

    /** 
     * Get the 'AddlTaxCode' element value. A qualifier to the Tax Code to distinguish taxes/fees/charges with the same tax code but with different business uses.
     * 
     * @return value
     */
    public String getAddlTaxCode() {
        return addlTaxCode;
    }

    /** 
     * Set the 'AddlTaxCode' element value. A qualifier to the Tax Code to distinguish taxes/fees/charges with the same tax code but with different business uses.
     * 
     * @param addlTaxCode
     */
    public void setAddlTaxCode(String addlTaxCode) {
        this.addlTaxCode = addlTaxCode;
    }

    /** 
     * Get the 'Amount' element value. Tax amount. Example: 15000 USD
     * 
     * @return value
     */
    public AmountType getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Tax amount. Example: 15000 USD
     * 
     * @param amount
     */
    public void setAmount(AmountType amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'ApproximateInd' element value. When true, this tax amount is approximate.
     * 
     * @return value
     */
    public Boolean getApproximateInd() {
        return approximateInd;
    }

    /** 
     * Set the 'ApproximateInd' element value. When true, this tax amount is approximate.
     * 
     * @param approximateInd
     */
    public void setApproximateInd(Boolean approximateInd) {
        this.approximateInd = approximateInd;
    }

    /** 
     * Get the 'AppTypeCode' element value. Indicates at which point the tax was applied (e.g. S - Sale, D - Departure, A - Arrival, X - Delivery).
     * 
     * @return value
     */
    public String getAppTypeCode() {
        return appTypeCode;
    }

    /** 
     * Set the 'AppTypeCode' element value. Indicates at which point the tax was applied (e.g. S - Sale, D - Departure, A - Arrival, X - Delivery).
     * 
     * @param appTypeCode
     */
    public void setAppTypeCode(String appTypeCode) {
        this.appTypeCode = appTypeCode;
    }

    /** 
     * Get the 'CollectionInd' element value. When true, this tax must be collected.
     * 
     * @return value
     */
    public Boolean getCollectionInd() {
        return collectionInd;
    }

    /** 
     * Set the 'CollectionInd' element value. When true, this tax must be collected.
     * 
     * @param collectionInd
     */
    public void setCollectionInd(Boolean collectionInd) {
        this.collectionInd = collectionInd;
    }

    /** 
     * Get the list of 'CollectionPointTax' element items. Tax data breakdown by collection point for XF(Passenger Facility Fee) and ZP(federal tax segment) taxes.
     * 
     * @return list
     */
    public List<CollectionPointTaxType> getCollectionPointTaxList() {
        return collectionPointTaxList;
    }

    /** 
     * Set the list of 'CollectionPointTax' element items. Tax data breakdown by collection point for XF(Passenger Facility Fee) and ZP(federal tax segment) taxes.
     * 
     * @param list
     */
    public void setCollectionPointTaxList(List<CollectionPointTaxType> list) {
        collectionPointTaxList = list;
    }

    /** 
     * Get the 'Country' element value. A nation with its own government, occupying a particular territory.
     * 
     * @return value
     */
    public CountryType getCountry() {
        return country;
    }

    /** 
     * Set the 'Country' element value. A nation with its own government, occupying a particular territory.
     * 
     * @param country
     */
    public void setCountry(CountryType country) {
        this.country = country;
    }

    /** 
     * Get the 'CountrySubDivision' element value. An area of land which is a sub-division within a country, such as a state, a county, a canton, a province, etc.
     * 
     * @return value
     */
    public CountrySubDivisionType getCountrySubDivision() {
        return countrySubDivision;
    }

    /** 
     * Set the 'CountrySubDivision' element value. An area of land which is a sub-division within a country, such as a state, a county, a canton, a province, etc.
     * 
     * @param countrySubDivision
     */
    public void setCountrySubDivision(CountrySubDivisionType countrySubDivision) {
        this.countrySubDivision = countrySubDivision;
    }

    /** 
     * Get the 'CurConversion' element value. The result of converting one currency into another currency. E.g. local currency to USD, air miles to monetary.
     * 
     * @return value
     */
    public CurConversionType getCurConversion() {
        return curConversion;
    }

    /** 
     * Set the 'CurConversion' element value. The result of converting one currency into another currency. E.g. local currency to USD, air miles to monetary.
     * 
     * @param curConversion
     */
    public void setCurConversion(CurConversionType curConversion) {
        this.curConversion = curConversion;
    }

    /** 
     * Get the 'DescText' element value. Tax short description. Example: $4 per flight segment, per passenger (U.S. domestic segment tax)
     * 
     * @return value
     */
    public String getDescText() {
        return descText;
    }

    /** 
     * Set the 'DescText' element value. Tax short description. Example: $4 per flight segment, per passenger (U.S. domestic segment tax)
     * 
     * @param descText
     */
    public void setDescText(String descText) {
        this.descText = descText;
    }

    /** 
     * Get the 'FiledAmount' element value. Internal tax filed amount as determined by the airline.
     * 
     * @return value
     */
    public AmountType getFiledAmount() {
        return filedAmount;
    }

    /** 
     * Set the 'FiledAmount' element value. Internal tax filed amount as determined by the airline.
     * 
     * @param filedAmount
     */
    public void setFiledAmount(AmountType filedAmount) {
        this.filedAmount = filedAmount;
    }

    /** 
     * Get the 'FiledTaxCode' element value. Internal tax filed type code as determined by the airline.
     * 
     * @return value
     */
    public String getFiledTaxCode() {
        return filedTaxCode;
    }

    /** 
     * Set the 'FiledTaxCode' element value. Internal tax filed type code as determined by the airline.
     * 
     * @param filedTaxCode
     */
    public void setFiledTaxCode(String filedTaxCode) {
        this.filedTaxCode = filedTaxCode;
    }

    /** 
     * Get the 'QualifierCode' element value. Used to specify if current, paid, additional taxes   Refer to IATA PADIS Code list data element 5305.
     * 
     * @return value
     */
    public String getQualifierCode() {
        return qualifierCode;
    }

    /** 
     * Set the 'QualifierCode' element value. Used to specify if current, paid, additional taxes   Refer to IATA PADIS Code list data element 5305.
     * 
     * @param qualifierCode
     */
    public void setQualifierCode(String qualifierCode) {
        this.qualifierCode = qualifierCode;
    }

    /** 
     * Get the 'RefundInd' element value. When true, this tax is refundable.
     * 
     * @return value
     */
    public Boolean getRefundInd() {
        return refundInd;
    }

    /** 
     * Set the 'RefundInd' element value. When true, this tax is refundable.
     * 
     * @param refundInd
     */
    public void setRefundInd(Boolean refundInd) {
        this.refundInd = refundInd;
    }

    /** 
     * Get the 'TaxCode' element value. IATA TTBS Tax Code. Example: AY, GB
     * 
     * @return value
     */
    public String getTaxCode() {
        return taxCode;
    }

    /** 
     * Set the 'TaxCode' element value. IATA TTBS Tax Code. Example: AY, GB
     * 
     * @param taxCode
     */
    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    /** 
     * Get the 'TaxName' element value. The name given to describe the tax. For example, this name can be taken from the IATA TTBS
     * 
     * @return value
     */
    public String getTaxName() {
        return taxName;
    }

    /** 
     * Set the 'TaxName' element value. The name given to describe the tax. For example, this name can be taken from the IATA TTBS
     * 
     * @param taxName
     */
    public void setTaxName(String taxName) {
        this.taxName = taxName;
    }

    /** 
     * Get the 'TaxTypeCode' element value. Tax type code (e.g. Applied or Exempt).
     * 
     * @return value
     */
    public TaxTypeCodeContentType getTaxTypeCode() {
        return taxTypeCode;
    }

    /** 
     * Set the 'TaxTypeCode' element value. Tax type code (e.g. Applied or Exempt).
     * 
     * @param taxTypeCode
     */
    public void setTaxTypeCode(TaxTypeCodeContentType taxTypeCode) {
        this.taxTypeCode = taxTypeCode;
    }
}
