
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;

/** 
 * Contains information related to potential business errors detected during processing of the preceding request.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="WarningType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Code" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="DescText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="LangCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OwnerName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="StatusText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TagText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="URL" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="WarningID" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class WarningType implements Serializable
{
    private String code;
    private String descText;
    private String langCode;
    private String ownerName;
    private String statusText;
    private String tagText;
    private String typeCode;
    private String URL;
    private String warningID;

    /** 
     * Get the 'Code' element value. The code corresponding to the processing warning as defined by PADIS 9321.
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'Code' element value. The code corresponding to the processing warning as defined by PADIS 9321.
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'DescText' element value. Free text description of the provided warning.
     * 
     * @return value
     */
    public String getDescText() {
        return descText;
    }

    /** 
     * Set the 'DescText' element value. Free text description of the provided warning.
     * 
     * @param descText
     */
    public void setDescText(String descText) {
        this.descText = descText;
    }

    /** 
     * Get the 'LangCode' element value. Language code associated with the warning response.
     * 
     * @return value
     */
    public String getLangCode() {
        return langCode;
    }

    /** 
     * Set the 'LangCode' element value. Language code associated with the warning response.
     * 
     * @param langCode
     */
    public void setLangCode(String langCode) {
        this.langCode = langCode;
    }

    /** 
     * Get the 'OwnerName' element value. The name of the organization owning the warning codelist.
     * 
     * @return value
     */
    public String getOwnerName() {
        return ownerName;
    }

    /** 
     * Set the 'OwnerName' element value. The name of the organization owning the warning codelist.
     * 
     * @param ownerName
     */
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    /** 
     * Get the 'StatusText' element value. Document processing status.  Recommended values are NotProcessed, Incomplete, Complete, Unknown.
     * 
     * @return value
     */
    public String getStatusText() {
        return statusText;
    }

    /** 
     * Set the 'StatusText' element value. Document processing status.  Recommended values are NotProcessed, Incomplete, Complete, Unknown.
     * 
     * @param statusText
     */
    public void setStatusText(String statusText) {
        this.statusText = statusText;
    }

    /** 
     * Get the 'TagText' element value. Identifies the tag/XPath which relates to the provided warning.
     * 
     * @return value
     */
    public String getTagText() {
        return tagText;
    }

    /** 
     * Set the 'TagText' element value. Identifies the tag/XPath which relates to the provided warning.
     * 
     * @param tagText
     */
    public void setTagText(String tagText) {
        this.tagText = tagText;
    }

    /** 
     * Get the 'TypeCode' element value. Uses a bilaterally agreed set of values to indicate the warning type.  The validating XSD can expect to accept values that it has not been explicitly coded for and process them by using Type = 'unknown'.
     * 
     * @return value
     */
    public String getTypeCode() {
        return typeCode;
    }

    /** 
     * Set the 'TypeCode' element value. Uses a bilaterally agreed set of values to indicate the warning type.  The validating XSD can expect to accept values that it has not been explicitly coded for and process them by using Type = 'unknown'.
     * 
     * @param typeCode
     */
    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    /** 
     * Get the 'URL' element value. Link to an online description of the provided warning.
     * 
     * @return value
     */
    public String getURL() {
        return URL;
    }

    /** 
     * Set the 'URL' element value. Link to an online description of the provided warning.
     * 
     * @param URL
     */
    public void setURL(String URL) {
        this.URL = URL;
    }

    /** 
     * Get the 'WarningID' element value. Unique identifier for this warning instance.
     * 
     * @return value
     */
    public String getWarningID() {
        return warningID;
    }

    /** 
     * Set the 'WarningID' element value. Unique identifier for this warning instance.
     * 
     * @param warningID
     */
    public void setWarningID(String warningID) {
        this.warningID = warningID;
    }
}
