
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq;

import java.io.Serializable;

/** 
 * Type of compartment of an aircraft, offering specific services (e.g. business class, economy).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CabinTypeType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CabinTypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CabinTypeName" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CabinTypeType implements Serializable
{
    private String cabinTypeCode;
    private String cabinTypeName;

    /** 
     * Get the 'CabinTypeCode' element value. Cabin Type Code as defined by PADIS codeset (e.g. 1, 2, 3, etc.)
     * 
     * @return value
     */
    public String getCabinTypeCode() {
        return cabinTypeCode;
    }

    /** 
     * Set the 'CabinTypeCode' element value. Cabin Type Code as defined by PADIS codeset (e.g. 1, 2, 3, etc.)
     * 
     * @param cabinTypeCode
     */
    public void setCabinTypeCode(String cabinTypeCode) {
        this.cabinTypeCode = cabinTypeCode;
    }

    /** 
     * Get the 'CabinTypeName' element value. Name given to a cabin compartment (e.g. Business, First, Economy).
     * 
     * @return value
     */
    public String getCabinTypeName() {
        return cabinTypeName;
    }

    /** 
     * Set the 'CabinTypeName' element value. Name given to a cabin compartment (e.g. Business, First, Economy).
     * 
     * @param cabinTypeName
     */
    public void setCabinTypeName(String cabinTypeName) {
        this.cabinTypeName = cabinTypeName;
    }
}
