
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq;

import java.io.Serializable;

/** 
 * System in which a corporation's travel agency bills employees for their business travel. The employee must then submit an expense accounting and be reimbursed by the corporation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DirectBillType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ContactInfoType" name="ContactInfo" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ContactRefID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OrgID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OrgName" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DirectBillType implements Serializable
{
    private ContactInfoType contactInfo;
    private String contactRefID;
    private String orgID;
    private String orgName;

    /** 
     * Get the 'ContactInfo' element value. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
     * 
     * @return value
     */
    public ContactInfoType getContactInfo() {
        return contactInfo;
    }

    /** 
     * Set the 'ContactInfo' element value. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
     * 
     * @param contactInfo
     */
    public void setContactInfo(ContactInfoType contactInfo) {
        this.contactInfo = contactInfo;
    }

    /** 
     * Get the 'ContactRefID' element value. Reference to a Contact ID within this message.
     * 
     * @return value
     */
    public String getContactRefID() {
        return contactRefID;
    }

    /** 
     * Set the 'ContactRefID' element value. Reference to a Contact ID within this message.
     * 
     * @param contactRefID
     */
    public void setContactRefID(String contactRefID) {
        this.contactRefID = contactRefID;
    }

    /** 
     * Get the 'OrgID' element value. The company ID to whom remittance should be directed. Example: IBM
     * 
     * @return value
     */
    public String getOrgID() {
        return orgID;
    }

    /** 
     * Set the 'OrgID' element value. The company ID to whom remittance should be directed. Example: IBM
     * 
     * @param orgID
     */
    public void setOrgID(String orgID) {
        this.orgID = orgID;
    }

    /** 
     * Get the 'OrgName' element value. The company name to whom remittance should be directed. Example: IBM
     * 
     * @return value
     */
    public String getOrgName() {
        return orgName;
    }

    /** 
     * Set the 'OrgName' element value. The company name to whom remittance should be directed. Example: IBM
     * 
     * @param orgName
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
}
