
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Filters based on Flight Number, Origin Destination, Segment, or Departure/Arrival.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightFilterCriteriaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ArrivalFilterCriteriaType" name="ArrivalFilterCriteria" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CabinTypeType" name="CabinTypeFilterCriteria" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DepFilterCriteriaType" name="DepFilterCriteria" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="FareBasisCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OriginDestFilterCriteriaType" name="OriginDestFilterCriteria" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:SegmentFilterCriteriaType" name="SegmentFilterCriteria" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlightFilterCriteriaType implements Serializable
{
    private ArrivalFilterCriteriaType arrivalFilterCriteria;
    private CabinTypeType cabinTypeFilterCriteria;
    private DepFilterCriteriaType depFilterCriteria;
    private String fareBasisCode;
    private OriginDestFilterCriteriaType originDestFilterCriteria;
    private List<SegmentFilterCriteriaType> segmentFilterCriteriaList = new ArrayList<SegmentFilterCriteriaType>();

    /** 
     * Get the 'ArrivalFilterCriteria' element value. Flight arrival information.
     * 
     * @return value
     */
    public ArrivalFilterCriteriaType getArrivalFilterCriteria() {
        return arrivalFilterCriteria;
    }

    /** 
     * Set the 'ArrivalFilterCriteria' element value. Flight arrival information.
     * 
     * @param arrivalFilterCriteria
     */
    public void setArrivalFilterCriteria(
            ArrivalFilterCriteriaType arrivalFilterCriteria) {
        this.arrivalFilterCriteria = arrivalFilterCriteria;
    }

    /** 
     * Get the 'CabinTypeFilterCriteria' element value. Type of compartment of an aircraft, offering specific services (e.g. business class, economy).
     * 
     * @return value
     */
    public CabinTypeType getCabinTypeFilterCriteria() {
        return cabinTypeFilterCriteria;
    }

    /** 
     * Set the 'CabinTypeFilterCriteria' element value. Type of compartment of an aircraft, offering specific services (e.g. business class, economy).
     * 
     * @param cabinTypeFilterCriteria
     */
    public void setCabinTypeFilterCriteria(CabinTypeType cabinTypeFilterCriteria) {
        this.cabinTypeFilterCriteria = cabinTypeFilterCriteria;
    }

    /** 
     * Get the 'DepFilterCriteria' element value. Flight departure information.
     * 
     * @return value
     */
    public DepFilterCriteriaType getDepFilterCriteria() {
        return depFilterCriteria;
    }

    /** 
     * Set the 'DepFilterCriteria' element value. Flight departure information.
     * 
     * @param depFilterCriteria
     */
    public void setDepFilterCriteria(DepFilterCriteriaType depFilterCriteria) {
        this.depFilterCriteria = depFilterCriteria;
    }

    /** 
     * Get the 'FareBasisCode' element value. Fare Basis Code (ex: Y26).
     * 
     * @return value
     */
    public String getFareBasisCode() {
        return fareBasisCode;
    }

    /** 
     * Set the 'FareBasisCode' element value. Fare Basis Code (ex: Y26).
     * 
     * @param fareBasisCode
     */
    public void setFareBasisCode(String fareBasisCode) {
        this.fareBasisCode = fareBasisCode;
    }

    /** 
     * Get the 'OriginDestFilterCriteria' element value. Filters results based on Origin Destination.
     * 
     * @return value
     */
    public OriginDestFilterCriteriaType getOriginDestFilterCriteria() {
        return originDestFilterCriteria;
    }

    /** 
     * Set the 'OriginDestFilterCriteria' element value. Filters results based on Origin Destination.
     * 
     * @param originDestFilterCriteria
     */
    public void setOriginDestFilterCriteria(
            OriginDestFilterCriteriaType originDestFilterCriteria) {
        this.originDestFilterCriteria = originDestFilterCriteria;
    }

    /** 
     * Get the list of 'SegmentFilterCriteria' element items. Filters results based on segment information.
     * 
     * @return list
     */
    public List<SegmentFilterCriteriaType> getSegmentFilterCriteriaList() {
        return segmentFilterCriteriaList;
    }

    /** 
     * Set the list of 'SegmentFilterCriteria' element items. Filters results based on segment information.
     * 
     * @param list
     */
    public void setSegmentFilterCriteriaList(
            List<SegmentFilterCriteriaType> list) {
        segmentFilterCriteriaList = list;
    }
}
