
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq;

import java.io.Serializable;

/** 
 * The OrderList transaction set retrieves a list of Orders that match one or more search criteria.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRQ" xmlns:ns1="http://xml.amadeus.com/QDQLRQ_11_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IATA_OrderListRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="AugmentationPoint" minOccurs="0">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element ref="ns1:Queue_List"/>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:MessageDocType" name="MessageDoc" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:PartyType" name="Party" minOccurs="1" maxOccurs="1"/>
 *       &lt;xs:element type="ns:IATA_PayloadStandardAttributesType" name="PayloadAttributes" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:POS_Type" name="POS" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:RequestType" name="Request" minOccurs="1" maxOccurs="1"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class IATAOrderListRQ implements Serializable
{
    private QueueList augmentationPoint;
    private MessageDocType messageDoc;
    private PartyType party;
    private IATAPayloadStandardAttributesType payloadAttributes;
    private POSType POS;
    private RequestType request;

    /** 
     * Get the 'Queue_List' element value. Implementer-Augmented Structure.
     * 
     * @return value
     */
    public QueueList getAugmentationPoint() {
        return augmentationPoint;
    }

    /** 
     * Set the 'Queue_List' element value. Implementer-Augmented Structure.
     * 
     * @param augmentationPoint
     */
    public void setAugmentationPoint(QueueList augmentationPoint) {
        this.augmentationPoint = augmentationPoint;
    }

    /** 
     * Get the 'MessageDoc' element value. NDC Message Document information.
     * 
     * @return value
     */
    public MessageDocType getMessageDoc() {
        return messageDoc;
    }

    /** 
     * Set the 'MessageDoc' element value. NDC Message Document information.
     * 
     * @param messageDoc
     */
    public void setMessageDoc(MessageDocType messageDoc) {
        this.messageDoc = messageDoc;
    }

    /** 
     * Get the 'Party' element value. NDC Message/ Transaction Party(s) information. Note that information about parties is intended for business use, it is not intended for transaction authentication and routing of the message.
     * 
     * @return value
     */
    public PartyType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value. NDC Message/ Transaction Party(s) information. Note that information about parties is intended for business use, it is not intended for transaction authentication and routing of the message.
     * 
     * @param party
     */
    public void setParty(PartyType party) {
        this.party = party;
    }

    /** 
     * Get the 'PayloadAttributes' element value. IATA Standard Payload attributes
     * 
     * @return value
     */
    public IATAPayloadStandardAttributesType getPayloadAttributes() {
        return payloadAttributes;
    }

    /** 
     * Set the 'PayloadAttributes' element value. IATA Standard Payload attributes
     * 
     * @param payloadAttributes
     */
    public void setPayloadAttributes(
            IATAPayloadStandardAttributesType payloadAttributes) {
        this.payloadAttributes = payloadAttributes;
    }

    /** 
     * Get the 'POS' element value. Point of Sale information.
     * 
     * @return value
     */
    public POSType getPOS() {
        return POS;
    }

    /** 
     * Set the 'POS' element value. Point of Sale information.
     * 
     * @param POS
     */
    public void setPOS(POSType POS) {
        this.POS = POS;
    }

    /** 
     * Get the 'Request' element value. OrderList request information.
     * 
     * @return value
     */
    public RequestType getRequest() {
        return request;
    }

    /** 
     * Set the 'Request' element value. OrderList request information.
     * 
     * @param request
     */
    public void setRequest(RequestType request) {
        this.request = request;
    }
}
