
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq;

import java.io.Serializable;

/** 
 * Order list request filter criteria.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderFilterCriteriaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:BookingRefType" name="BookingRefFilterCriteria" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CarrierType" name="CarrierFilterCriteria" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:FlightFilterCriteriaType" name="FlightFilterCriteria" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateRangeType" name="OrderCancellationDateFilterCriteria" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateRangeType" name="CreationDateTimeFilterCriteria" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateRangeType" name="LastModifiedDateTimeFilterCriteria" minOccurs="0"/>
 *     &lt;xs:element type="ns:PaxType" name="PaxFilterCriteria" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaxGroupType" name="PaxGroupFilterCriteria" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaymentInfoType" name="PaymentFilterCriteria" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ServiceType" name="ServiceFilterCriteria" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:TicketType" name="TicketFilterCriteria" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateRangeType" name="TravelDateFilterCriteria" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OrderFilterCriteriaType implements Serializable
{
    private BookingRefType bookingRefFilterCriteria;
    private CarrierType carrierFilterCriteria;
    private FlightFilterCriteriaType flightFilterCriteria;
    private DateRangeType orderCancellationDateFilterCriteria;
    private DateRangeType creationDateTimeFilterCriteria;
    private DateRangeType lastModifiedDateTimeFilterCriteria;
    private PaxType paxFilterCriteria;
    private PaxGroupType paxGroupFilterCriteria;
    private PaymentInfoType paymentFilterCriteria;
    private ServiceType serviceFilterCriteria;
    private TicketType ticketFilterCriteria;
    private DateRangeType travelDateFilterCriteria;

    /** 
     * Get the 'BookingRefFilterCriteria' element value. Information related to a booking or reservation.
     * 
     * @return value
     */
    public BookingRefType getBookingRefFilterCriteria() {
        return bookingRefFilterCriteria;
    }

    /** 
     * Set the 'BookingRefFilterCriteria' element value. Information related to a booking or reservation.
     * 
     * @param bookingRefFilterCriteria
     */
    public void setBookingRefFilterCriteria(
            BookingRefType bookingRefFilterCriteria) {
        this.bookingRefFilterCriteria = bookingRefFilterCriteria;
    }

    /** 
     * Get the 'CarrierFilterCriteria' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @return value
     */
    public CarrierType getCarrierFilterCriteria() {
        return carrierFilterCriteria;
    }

    /** 
     * Set the 'CarrierFilterCriteria' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @param carrierFilterCriteria
     */
    public void setCarrierFilterCriteria(CarrierType carrierFilterCriteria) {
        this.carrierFilterCriteria = carrierFilterCriteria;
    }

    /** 
     * Get the 'FlightFilterCriteria' element value. Filters based on Flight Number, Origin Destination, Segment, or Departure/Arrival.
     * 
     * @return value
     */
    public FlightFilterCriteriaType getFlightFilterCriteria() {
        return flightFilterCriteria;
    }

    /** 
     * Set the 'FlightFilterCriteria' element value. Filters based on Flight Number, Origin Destination, Segment, or Departure/Arrival.
     * 
     * @param flightFilterCriteria
     */
    public void setFlightFilterCriteria(
            FlightFilterCriteriaType flightFilterCriteria) {
        this.flightFilterCriteria = flightFilterCriteria;
    }

    /** 
     * Get the 'OrderCancellationDateFilterCriteria' element value. Order cancellation date range.  Any Order cancellation date falling within this range should be returned in the results.
     * 
     * @return value
     */
    public DateRangeType getOrderCancellationDateFilterCriteria() {
        return orderCancellationDateFilterCriteria;
    }

    /** 
     * Set the 'OrderCancellationDateFilterCriteria' element value. Order cancellation date range.  Any Order cancellation date falling within this range should be returned in the results.
     * 
     * @param orderCancellationDateFilterCriteria
     */
    public void setOrderCancellationDateFilterCriteria(
            DateRangeType orderCancellationDateFilterCriteria) {
        this.orderCancellationDateFilterCriteria = orderCancellationDateFilterCriteria;
    }

    /** 
     * Get the 'CreationDateTimeFilterCriteria' element value. Order creation date range.  Any Order creation date falling within this range should be returned in the results.
     * 
     * @return value
     */
    public DateRangeType getCreationDateTimeFilterCriteria() {
        return creationDateTimeFilterCriteria;
    }

    /** 
     * Set the 'CreationDateTimeFilterCriteria' element value. Order creation date range.  Any Order creation date falling within this range should be returned in the results.
     * 
     * @param creationDateTimeFilterCriteria
     */
    public void setCreationDateTimeFilterCriteria(
            DateRangeType creationDateTimeFilterCriteria) {
        this.creationDateTimeFilterCriteria = creationDateTimeFilterCriteria;
    }

    /** 
     * Get the 'LastModifiedDateTimeFilterCriteria' element value. Order creation date range.  Any Order creation date falling within this range should be returned in the results.
     * 
     * @return value
     */
    public DateRangeType getLastModifiedDateTimeFilterCriteria() {
        return lastModifiedDateTimeFilterCriteria;
    }

    /** 
     * Set the 'LastModifiedDateTimeFilterCriteria' element value. Order creation date range.  Any Order creation date falling within this range should be returned in the results.
     * 
     * @param lastModifiedDateTimeFilterCriteria
     */
    public void setLastModifiedDateTimeFilterCriteria(
            DateRangeType lastModifiedDateTimeFilterCriteria) {
        this.lastModifiedDateTimeFilterCriteria = lastModifiedDateTimeFilterCriteria;
    }

    /** 
     * Get the 'PaxFilterCriteria' element value. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship. Holds the attributes specific to a one booking, from shopping to fulfillment.
     * 
     * @return value
     */
    public PaxType getPaxFilterCriteria() {
        return paxFilterCriteria;
    }

    /** 
     * Set the 'PaxFilterCriteria' element value. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship. Holds the attributes specific to a one booking, from shopping to fulfillment.
     * 
     * @param paxFilterCriteria
     */
    public void setPaxFilterCriteria(PaxType paxFilterCriteria) {
        this.paxFilterCriteria = paxFilterCriteria;
    }

    /** 
     * Get the 'PaxGroupFilterCriteria' element value. A number of individual passengers traveling under one commercial name that associates them. E.g. a Tour group or a group for sales allotment from airline to agency.
     * 
     * @return value
     */
    public PaxGroupType getPaxGroupFilterCriteria() {
        return paxGroupFilterCriteria;
    }

    /** 
     * Set the 'PaxGroupFilterCriteria' element value. A number of individual passengers traveling under one commercial name that associates them. E.g. a Tour group or a group for sales allotment from airline to agency.
     * 
     * @param paxGroupFilterCriteria
     */
    public void setPaxGroupFilterCriteria(PaxGroupType paxGroupFilterCriteria) {
        this.paxGroupFilterCriteria = paxGroupFilterCriteria;
    }

    /** 
     * Get the 'PaymentFilterCriteria' element value. Information related to the settlement of a transaction through monetary or other compensations. For example, a payment may be applied to an entire Order or individual Order Items.
     * 
     * @return value
     */
    public PaymentInfoType getPaymentFilterCriteria() {
        return paymentFilterCriteria;
    }

    /** 
     * Set the 'PaymentFilterCriteria' element value. Information related to the settlement of a transaction through monetary or other compensations. For example, a payment may be applied to an entire Order or individual Order Items.
     * 
     * @param paymentFilterCriteria
     */
    public void setPaymentFilterCriteria(PaymentInfoType paymentFilterCriteria) {
        this.paymentFilterCriteria = paymentFilterCriteria;
    }

    /** 
     * Get the 'ServiceFilterCriteria' element value. The instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order.
     * 
     * @return value
     */
    public ServiceType getServiceFilterCriteria() {
        return serviceFilterCriteria;
    }

    /** 
     * Set the 'ServiceFilterCriteria' element value. The instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order.
     * 
     * @param serviceFilterCriteria
     */
    public void setServiceFilterCriteria(ServiceType serviceFilterCriteria) {
        this.serviceFilterCriteria = serviceFilterCriteria;
    }

    /** 
     * Get the 'TicketFilterCriteria' element value. The accountable document issued by or on behalf of a carrier which includes notices and the flight and passenger coupons contained therein.
     * 
     * @return value
     */
    public TicketType getTicketFilterCriteria() {
        return ticketFilterCriteria;
    }

    /** 
     * Set the 'TicketFilterCriteria' element value. The accountable document issued by or on behalf of a carrier which includes notices and the flight and passenger coupons contained therein.
     * 
     * @param ticketFilterCriteria
     */
    public void setTicketFilterCriteria(TicketType ticketFilterCriteria) {
        this.ticketFilterCriteria = ticketFilterCriteria;
    }

    /** 
     * Get the 'TravelDateFilterCriteria' element value. Travel/Journey date range.  Any Order containing Journey dates falling within this range should be returned in the results.
     * 
     * @return value
     */
    public DateRangeType getTravelDateFilterCriteria() {
        return travelDateFilterCriteria;
    }

    /** 
     * Set the 'TravelDateFilterCriteria' element value. Travel/Journey date range.  Any Order containing Journey dates falling within this range should be returned in the results.
     * 
     * @param travelDateFilterCriteria
     */
    public void setTravelDateFilterCriteria(
            DateRangeType travelDateFilterCriteria) {
        this.travelDateFilterCriteria = travelDateFilterCriteria;
    }
}
