
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * request of date deferred PNR queue counts
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://xml.amadeus.com/QDQLRQ_11_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Queue_List">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:ActionDetailsTypeI" name="scroll" minOccurs="0"/>
 *       &lt;xs:element type="ns:AdditionalBusinessSourceInformationTypeI" name="targetOffice" minOccurs="0"/>
 *       &lt;xs:element type="ns:QueueInformationTypeI" name="queueNumber" minOccurs="0"/>
 *       &lt;xs:element type="ns:SubQueueInformationTypeI" name="categoryDetails" minOccurs="0"/>
 *       &lt;xs:element type="ns:StructuredDateTimeInformationType" name="date" minOccurs="0"/>
 *       &lt;xs:element type="ns:RangeDetailsTypeI" name="scanRange" minOccurs="0"/>
 *       &lt;xs:element name="searchCriteria" minOccurs="0" maxOccurs="3">
 *         &lt;!-- Reference to inner class SearchCriteria -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:TravellerInformationTypeI" name="passengerName" minOccurs="0" maxOccurs="5"/>
 *       &lt;xs:element type="ns:UserIdentificationType" name="agentSine" minOccurs="0"/>
 *       &lt;xs:element type="ns:AccountingInformationElementType" name="accountNumber" minOccurs="0"/>
 *       &lt;xs:element name="flightInformation" minOccurs="0" maxOccurs="5">
 *         &lt;!-- Reference to inner class FlightInformation -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:PointOfSaleInformationType" name="pos" minOccurs="0" maxOccurs="5"/>
 *       &lt;xs:element type="ns:FrequentTravellerIdentificationCodeType" name="tierLevelAndCustomerValue" minOccurs="0" maxOccurs="10"/>
 *       &lt;xs:element name="sortCriteria" minOccurs="0">
 *         &lt;!-- Reference to inner class SortCriteria -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class QueueList implements Serializable
{
    private ActionDetailsTypeI scroll;
    private AdditionalBusinessSourceInformationTypeI targetOffice;
    private QueueInformationTypeI queueNumber;
    private SubQueueInformationTypeI categoryDetails;
    private StructuredDateTimeInformationType date;
    private RangeDetailsTypeI scanRange;
    private List<SearchCriteria> searchCriteriaList = new ArrayList<SearchCriteria>();
    private List<TravellerInformationTypeI> passengerNameList = new ArrayList<TravellerInformationTypeI>();
    private UserIdentificationType agentSine;
    private AccountingInformationElementType accountNumber;
    private List<FlightInformation> flightInformationList = new ArrayList<FlightInformation>();
    private List<PointOfSaleInformationType> poList = new ArrayList<PointOfSaleInformationType>();
    private List<FrequentTravellerIdentificationCodeType> tierLevelAndCustomerValueList = new ArrayList<FrequentTravellerIdentificationCodeType>();
    private SortCriteria sortCriteria;

    /** 
     * Get the 'scroll' element value. presence implies that this is a follow up scrolling entry to a previous entry. Absence implies start of a new search
     * 
     * @return value
     */
    public ActionDetailsTypeI getScroll() {
        return scroll;
    }

    /** 
     * Set the 'scroll' element value. presence implies that this is a follow up scrolling entry to a previous entry. Absence implies start of a new search
     * 
     * @param scroll
     */
    public void setScroll(ActionDetailsTypeI scroll) {
        this.scroll = scroll;
    }

    /** 
     * Get the 'targetOffice' element value. used to specify the target office for which the queue count is to be displayed
     * 
     * @return value
     */
    public AdditionalBusinessSourceInformationTypeI getTargetOffice() {
        return targetOffice;
    }

    /** 
     * Set the 'targetOffice' element value. used to specify the target office for which the queue count is to be displayed
     * 
     * @param targetOffice
     */
    public void setTargetOffice(
            AdditionalBusinessSourceInformationTypeI targetOffice) {
        this.targetOffice = targetOffice;
    }

    /** 
     * Get the 'queueNumber' element value. used to specify the queue if required
     * 
     * @return value
     */
    public QueueInformationTypeI getQueueNumber() {
        return queueNumber;
    }

    /** 
     * Set the 'queueNumber' element value. used to specify the queue if required
     * 
     * @param queueNumber
     */
    public void setQueueNumber(QueueInformationTypeI queueNumber) {
        this.queueNumber = queueNumber;
    }

    /** 
     * Get the 'categoryDetails' element value. used to select the category
     * 
     * @return value
     */
    public SubQueueInformationTypeI getCategoryDetails() {
        return categoryDetails;
    }

    /** 
     * Set the 'categoryDetails' element value. used to select the category
     * 
     * @param categoryDetails
     */
    public void setCategoryDetails(SubQueueInformationTypeI categoryDetails) {
        this.categoryDetails = categoryDetails;
    }

    /** 
     * Get the 'date' element value. date range as system defined
     * 
     * @return value
     */
    public StructuredDateTimeInformationType getDate() {
        return date;
    }

    /** 
     * Set the 'date' element value. date range as system defined
     * 
     * @param date
     */
    public void setDate(StructuredDateTimeInformationType date) {
        this.date = date;
    }

    /** 
     * Get the 'scanRange' element value. defines the start point for the search and may also define the end point of the search
     * 
     * @return value
     */
    public RangeDetailsTypeI getScanRange() {
        return scanRange;
    }

    /** 
     * Set the 'scanRange' element value. defines the start point for the search and may also define the end point of the search
     * 
     * @param scanRange
     */
    public void setScanRange(RangeDetailsTypeI scanRange) {
        this.scanRange = scanRange;
    }

    /** 
     * Get the list of 'searchCriteria' element items.
     * 
     * @return list
     */
    public List<SearchCriteria> getSearchCriteriaList() {
        return searchCriteriaList;
    }

    /** 
     * Set the list of 'searchCriteria' element items.
     * 
     * @param list
     */
    public void setSearchCriteriaList(List<SearchCriteria> list) {
        searchCriteriaList = list;
    }

    /** 
     * Get the list of 'passengerName' element items. Passenger name list (all the names in the PNR).
     * 
     * @return list
     */
    public List<TravellerInformationTypeI> getPassengerNameList() {
        return passengerNameList;
    }

    /** 
     * Set the list of 'passengerName' element items. Passenger name list (all the names in the PNR).
     * 
     * @param list
     */
    public void setPassengerNameList(List<TravellerInformationTypeI> list) {
        passengerNameList = list;
    }

    /** 
     * Get the 'agentSine' element value. The last 2 characters of the sine of the agent who placed the PNR on queue.
     * 
     * @return value
     */
    public UserIdentificationType getAgentSine() {
        return agentSine;
    }

    /** 
     * Set the 'agentSine' element value. The last 2 characters of the sine of the agent who placed the PNR on queue.
     * 
     * @param agentSine
     */
    public void setAgentSine(UserIdentificationType agentSine) {
        this.agentSine = agentSine;
    }

    /** 
     * Get the 'accountNumber' element value. Account number issue from AIAN entry in the PNR.
     * 
     * @return value
     */
    public AccountingInformationElementType getAccountNumber() {
        return accountNumber;
    }

    /** 
     * Set the 'accountNumber' element value. Account number issue from AIAN entry in the PNR.
     * 
     * @param accountNumber
     */
    public void setAccountNumber(AccountingInformationElementType accountNumber) {
        this.accountNumber = accountNumber;
    }

    /** 
     * Get the list of 'flightInformation' element items.
     * 
     * @return list
     */
    public List<FlightInformation> getFlightInformationList() {
        return flightInformationList;
    }

    /** 
     * Set the list of 'flightInformation' element items.
     * 
     * @param list
     */
    public void setFlightInformationList(List<FlightInformation> list) {
        flightInformationList = list;
    }

    /** 
     * Get the list of 'pos' element items. This is the point of sale of segments in PNRs: - 9 char Amadeus Office ID. - OR 2 char GDS code for OA PNRs  PNRs containing a segment sold in any Amadeus Office ID matching pattern NCE6X*** or ***BA0*** or sold in Sabre (1S) or Gallileo (1G).
     * 
     * @return list
     */
    public List<PointOfSaleInformationType> getPoList() {
        return poList;
    }

    /** 
     * Set the list of 'pos' element items. This is the point of sale of segments in PNRs: - 9 char Amadeus Office ID. - OR 2 char GDS code for OA PNRs  PNRs containing a segment sold in any Amadeus Office ID matching pattern NCE6X*** or ***BA0*** or sold in Sabre (1S) or Gallileo (1G).
     * 
     * @param list
     */
    public void setPoList(List<PointOfSaleInformationType> list) {
        poList = list;
    }

    /** 
     * Get the list of 'tierLevelAndCustomerValue' element items. The repetition is 10 because we can transport: - until 5 tierLevel - until 5 customerValue, including possibly range of customerValue.  If we have tierLevel in the FTI, the customerValue must not be present. If we have customerValue in the FTI, the tierLevel must not be present.
     * 
     * @return list
     */
    public List<FrequentTravellerIdentificationCodeType> getTierLevelAndCustomerValueList() {
        return tierLevelAndCustomerValueList;
    }

    /** 
     * Set the list of 'tierLevelAndCustomerValue' element items. The repetition is 10 because we can transport: - until 5 tierLevel - until 5 customerValue, including possibly range of customerValue.  If we have tierLevel in the FTI, the customerValue must not be present. If we have customerValue in the FTI, the tierLevel must not be present.
     * 
     * @param list
     */
    public void setTierLevelAndCustomerValueList(
            List<FrequentTravellerIdentificationCodeType> list) {
        tierLevelAndCustomerValueList = list;
    }

    /** 
     * Get the 'sortCriteria' element value.
     * 
     * @return value
     */
    public SortCriteria getSortCriteria() {
        return sortCriteria;
    }

    /** 
     * Set the 'sortCriteria' element value.
     * 
     * @param sortCriteria
     */
    public void setSortCriteria(SortCriteria sortCriteria) {
        this.sortCriteria = sortCriteria;
    }
    /** 
     * used to add the search options. There are only 3 search options that specify date ranges ticketing date range departure date range Creation date range all are allowed together
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://xml.amadeus.com/QDQLRQ_11_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="searchCriteria" minOccurs="0" maxOccurs="3">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:SelectionDetailsTypeI" name="searchOption"/>
     *       &lt;xs:element type="ns:StructuredPeriodInformationType" name="dates" maxOccurs="5"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SearchCriteria implements Serializable
    {
        private SelectionDetailsTypeI searchOption;
        private List<StructuredPeriodInformationType> dateList = new ArrayList<StructuredPeriodInformationType>();

        /** 
         * Get the 'searchOption' element value. used to specify if ticketing, departure or creation options
         * 
         * @return value
         */
        public SelectionDetailsTypeI getSearchOption() {
            return searchOption;
        }

        /** 
         * Set the 'searchOption' element value. used to specify if ticketing, departure or creation options
         * 
         * @param searchOption
         */
        public void setSearchOption(SelectionDetailsTypeI searchOption) {
            this.searchOption = searchOption;
        }

        /** 
         * Get the list of 'dates' element items. used to specify the dates to be searched on
         * 
         * @return list
         */
        public List<StructuredPeriodInformationType> getDateList() {
            return dateList;
        }

        /** 
         * Set the list of 'dates' element items. used to specify the dates to be searched on
         * 
         * @param list
         */
        public void setDateList(List<StructuredPeriodInformationType> list) {
            dateList = list;
        }
    }
    /** 
     * Flight search criteria.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://xml.amadeus.com/QDQLRQ_11_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="flightInformation" minOccurs="0" maxOccurs="5">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:StatusTypeI" name="flightInformationType"/>
     *       &lt;xs:element type="ns:OriginAndDestinationDetailsTypeI" name="boardPointOrOffPoint" minOccurs="0" maxOccurs="5"/>
     *       &lt;xs:element type="ns:TransportIdentifierType" name="airlineCodeOrFlightNumber" minOccurs="0" maxOccurs="5"/>
     *       &lt;xs:element type="ns:ProductInformationTypeI" name="classOfService" minOccurs="0" maxOccurs="5"/>
     *       &lt;xs:element type="ns:RelatedProductInformationTypeI" name="segmentStatus" minOccurs="0" maxOccurs="5"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FlightInformation implements Serializable
    {
        private StatusTypeI flightInformationType;
        private List<OriginAndDestinationDetailsTypeI> boardPointOrOffPointList = new ArrayList<OriginAndDestinationDetailsTypeI>();
        private List<TransportIdentifierType> airlineCodeOrFlightNumberList = new ArrayList<TransportIdentifierType>();
        private List<ProductInformationTypeI> classOfServiceList = new ArrayList<ProductInformationTypeI>();
        private List<RelatedProductInformationTypeI> segmentStatuList = new ArrayList<RelatedProductInformationTypeI>();

        /** 
         * Get the 'flightInformationType' element value. It transport the type of flight information that will follow.
         * 
         * @return value
         */
        public StatusTypeI getFlightInformationType() {
            return flightInformationType;
        }

        /** 
         * Set the 'flightInformationType' element value. It transport the type of flight information that will follow.
         * 
         * @param flightInformationType
         */
        public void setFlightInformationType(StatusTypeI flightInformationType) {
            this.flightInformationType = flightInformationType;
        }

        /** 
         * Get the list of 'boardPointOrOffPoint' element items. Board point or Off Point.
         * 
         * @return list
         */
        public List<OriginAndDestinationDetailsTypeI> getBoardPointOrOffPointList() {
            return boardPointOrOffPointList;
        }

        /** 
         * Set the list of 'boardPointOrOffPoint' element items. Board point or Off Point.
         * 
         * @param list
         */
        public void setBoardPointOrOffPointList(
                List<OriginAndDestinationDetailsTypeI> list) {
            boardPointOrOffPointList = list;
        }

        /** 
         * Get the list of 'airlineCodeOrFlightNumber' element items. Airline code or Flight Number (in fact, airline + flight number)
         * 
         * @return list
         */
        public List<TransportIdentifierType> getAirlineCodeOrFlightNumberList() {
            return airlineCodeOrFlightNumberList;
        }

        /** 
         * Set the list of 'airlineCodeOrFlightNumber' element items. Airline code or Flight Number (in fact, airline + flight number)
         * 
         * @param list
         */
        public void setAirlineCodeOrFlightNumberList(
                List<TransportIdentifierType> list) {
            airlineCodeOrFlightNumberList = list;
        }

        /** 
         * Get the list of 'classOfService' element items. Booking class.
         * 
         * @return list
         */
        public List<ProductInformationTypeI> getClassOfServiceList() {
            return classOfServiceList;
        }

        /** 
         * Set the list of 'classOfService' element items. Booking class.
         * 
         * @param list
         */
        public void setClassOfServiceList(List<ProductInformationTypeI> list) {
            classOfServiceList = list;
        }

        /** 
         * Get the list of 'segmentStatus' element items. Segment status code.
         * 
         * @return list
         */
        public List<RelatedProductInformationTypeI> getSegmentStatuList() {
            return segmentStatuList;
        }

        /** 
         * Set the list of 'segmentStatus' element items. Segment status code.
         * 
         * @param list
         */
        public void setSegmentStatuList(
                List<RelatedProductInformationTypeI> list) {
            segmentStatuList = list;
        }
    }
    /** 
     * to determine the order of the display
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://xml.amadeus.com/QDQLRQ_11_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="sortCriteria" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:DummySegmentTypeI" name="dumbo"/>
     *       &lt;xs:element type="ns:SelectionDetailsTypeI" name="sortOption" maxOccurs="3"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SortCriteria implements Serializable
    {
        private DummySegmentTypeI dumbo;
        private List<SelectionDetailsTypeI> sortOptionList = new ArrayList<SelectionDetailsTypeI>();

        /** 
         * Get the 'dumbo' element value. dummy for SDT clash
         * 
         * @return value
         */
        public DummySegmentTypeI getDumbo() {
            return dumbo;
        }

        /** 
         * Set the 'dumbo' element value. dummy for SDT clash
         * 
         * @param dumbo
         */
        public void setDumbo(DummySegmentTypeI dumbo) {
            this.dumbo = dumbo;
        }

        /** 
         * Get the list of 'sortOption' element items. Determine the order of the display.
         * 
         * @return list
         */
        public List<SelectionDetailsTypeI> getSortOptionList() {
            return sortOptionList;
        }

        /** 
         * Set the list of 'sortOption' element items. Determine the order of the display.
         * 
         * @param list
         */
        public void setSortOptionList(List<SelectionDetailsTypeI> list) {
            sortOptionList = list;
        }
    }
}
