
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A company that partners with a manufacturer or producer to market and sell the manufacturer's products, services, or technologies.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetailPartnerType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ContactInfoType" name="ContactInfo" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="Name" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RetailPartnerID" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RetailPartnerType implements Serializable
{
    private List<ContactInfoType> contactInfoList = new ArrayList<ContactInfoType>();
    private String name;
    private String retailPartnerID;

    /** 
     * Get the list of 'ContactInfo' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
     * 
     * @return list
     */
    public List<ContactInfoType> getContactInfoList() {
        return contactInfoList;
    }

    /** 
     * Set the list of 'ContactInfo' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
     * 
     * @param list
     */
    public void setContactInfoList(List<ContactInfoType> list) {
        contactInfoList = list;
    }

    /** 
     * Get the 'Name' element value. Retail partner name.
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Retail partner name.
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'RetailPartnerID' element value. Unique Retailer ID
     * 
     * @return value
     */
    public String getRetailPartnerID() {
        return retailPartnerID;
    }

    /** 
     * Set the 'RetailPartnerID' element value. Unique Retailer ID
     * 
     * @param retailPartnerID
     */
    public void setRetailPartnerID(String retailPartnerID) {
        this.retailPartnerID = retailPartnerID;
    }
}
