
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq;

import java.io.Serializable;

/** 
 * shows the possible statuses of a service item
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceDeliveryStatusContentType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="DELIVERED"/>
 *     &lt;xs:enumeration value="EXPIRED"/>
 *     &lt;xs:enumeration value="FAILED TO DELIVER"/>
 *     &lt;xs:enumeration value="IN PROGRESS"/>
 *     &lt;xs:enumeration value="NOT CLAIMED"/>
 *     &lt;xs:enumeration value="READY TO DELIVER"/>
 *     &lt;xs:enumeration value="READY TO PROCEED"/>
 *     &lt;xs:enumeration value="REMOVED"/>
 *     &lt;xs:enumeration value="SUSPENDED"/>
 *     &lt;xs:enumeration value="UNABLE TO DELIVER"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum ServiceDeliveryStatusContentType implements Serializable {
    /** 
     * Service has been successfully delivered.
     */
    DELIVERED("DELIVERED"), /** 
                             * Service is no longer available for delivery. Service purchased with an associated time limit for consumption and Service was never claimed. Service having been at least Confirmed is no longer available as the Customer did not claim the Service within a specific time period, as dictated by the Airline.
                             */
    EXPIRED("EXPIRED"), /** 
                         * Service could not be delivered due to AirlineÂ´s or provider limitations.
                         */
    FAILEDTODELIVER("FAILED TO DELIVER"), /** 
                                           * The DP is in the process of delivering the Service. There is a universal concept that the â€œIn progressâ€&#157; status may block any further financial transactions; e.g. refund
                                           */
    INPROGRESS("IN PROGRESS"), /** 
                                * The Service has not been claimed by the Passenger for reasons as a result of Passenger action or inaction. e.g. Passenger no-show, etc.
                                */
    NOTCLAIMED("NOT CLAIMED"), /** 
                                * Provider is in a position to start delivery of the Service.
                                */
    READYTODELIVER("READY TO DELIVER"), /** 
                                         * OM is in a position to allow a DP to prepare the Service. Customer is entitled to receive the Service. This is typically a trigger for ORA to begin accounting process.
                                         */
    READYTOPROCEED("READY TO PROCEED"), /** 
                                         * Service was deleted.
                                         */
    REMOVED("REMOVED"), /** 
                         * Delivery of the Service is suspended as a result of an Airline decision.   Can only revert back to the previous status. Exception is that Suspended may go to Removed.  This status may be used in case of fraud detection.
                         */
    SUSPENDED("SUSPENDED"), /** 
                             * It is not possible for the DP to deliver a Service. This could be for reasons of availability, legal or regulatory constraint.
                             */
    UNABLETODELIVER("UNABLE TO DELIVER");
    private final String value;

    private ServiceDeliveryStatusContentType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static ServiceDeliveryStatusContentType convert(String value) {
        for (ServiceDeliveryStatusContentType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
