
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq;

import java.io.Serializable;

/** 
 * The instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ServiceBookingStatusContentType" name="BookingStatusCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ServiceDeliveryStatusContentType" name="DeliveryStatusCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="DescText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ServiceID" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceType implements Serializable
{
    private ServiceBookingStatusContentType bookingStatusCode;
    private ServiceDeliveryStatusContentType deliveryStatusCode;
    private String descText;
    private String serviceID;

    /** 
     * Get the 'BookingStatusCode' element value. Indicates the current status of a Service booking.
     * 
     * @return value
     */
    public ServiceBookingStatusContentType getBookingStatusCode() {
        return bookingStatusCode;
    }

    /** 
     * Set the 'BookingStatusCode' element value. Indicates the current status of a Service booking.
     * 
     * @param bookingStatusCode
     */
    public void setBookingStatusCode(
            ServiceBookingStatusContentType bookingStatusCode) {
        this.bookingStatusCode = bookingStatusCode;
    }

    /** 
     * Get the 'DeliveryStatusCode' element value. Indicates the current status of a Service delivery
     * 
     * @return value
     */
    public ServiceDeliveryStatusContentType getDeliveryStatusCode() {
        return deliveryStatusCode;
    }

    /** 
     * Set the 'DeliveryStatusCode' element value. Indicates the current status of a Service delivery
     * 
     * @param deliveryStatusCode
     */
    public void setDeliveryStatusCode(
            ServiceDeliveryStatusContentType deliveryStatusCode) {
        this.deliveryStatusCode = deliveryStatusCode;
    }

    /** 
     * Get the 'DescText' element value. Free text for textual description.
     * 
     * @return value
     */
    public String getDescText() {
        return descText;
    }

    /** 
     * Set the 'DescText' element value. Free text for textual description.
     * 
     * @param descText
     */
    public void setDescText(String descText) {
        this.descText = descText;
    }

    /** 
     * Get the 'ServiceID' element value. Uniquely Identifies a Service within the context of one message.
     * 
     * @return value
     */
    public String getServiceID() {
        return serviceID;
    }

    /** 
     * Set the 'ServiceID' element value. Uniquely Identifies a Service within the context of one message.
     * 
     * @param serviceID
     */
    public void setServiceID(String serviceID) {
        this.serviceID = serviceID;
    }
}
