
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq;

import java.io.Serializable;
import java.sql.Date;

/** 
 * The issuing carrier and issuing location of a ticket.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketIssuanceInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="IATA_LocationCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:date" name="IssueDate" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CarrierType" name="IssuingCarrier" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:TravelAgencyType" name="TravelAgency" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TicketIssuanceInfoType implements Serializable
{
    private String IATALocationCode;
    private Date issueDate;
    private CarrierType issuingCarrier;
    private TravelAgencyType travelAgency;

    /** 
     * Get the 'IATA_LocationCode' element value. IATA defined code identifying a city or station.
     * 
     * @return value
     */
    public String getIATALocationCode() {
        return IATALocationCode;
    }

    /** 
     * Set the 'IATA_LocationCode' element value. IATA defined code identifying a city or station.
     * 
     * @param IATALocationCode
     */
    public void setIATALocationCode(String IATALocationCode) {
        this.IATALocationCode = IATALocationCode;
    }

    /** 
     * Get the 'IssueDate' element value. The date that the document was originally issued.
     * 
     * @return value
     */
    public Date getIssueDate() {
        return issueDate;
    }

    /** 
     * Set the 'IssueDate' element value. The date that the document was originally issued.
     * 
     * @param issueDate
     */
    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    /** 
     * Get the 'IssuingCarrier' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @return value
     */
    public CarrierType getIssuingCarrier() {
        return issuingCarrier;
    }

    /** 
     * Set the 'IssuingCarrier' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @param issuingCarrier
     */
    public void setIssuingCarrier(CarrierType issuingCarrier) {
        this.issuingCarrier = issuingCarrier;
    }

    /** 
     * Get the 'TravelAgency' element value. A private retailer or public service that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package tours.
     * 
     * @return value
     */
    public TravelAgencyType getTravelAgency() {
        return travelAgency;
    }

    /** 
     * Set the 'TravelAgency' element value. A private retailer or public service that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package tours.
     * 
     * @param travelAgency
     */
    public void setTravelAgency(TravelAgencyType travelAgency) {
        this.travelAgency = travelAgency;
    }
}
