
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq;

import java.io.Serializable;
import java.sql.Date;

/** 
 * A document that entitles the holder to a discount or that may be exchanged for goods or services.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VoucherType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:date" name="EffectiveDate" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:date" name="ExpirationDate" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:AmountType" name="RemainingAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="VoucherID" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class VoucherType implements Serializable
{
    private Date effectiveDate;
    private Date expirationDate;
    private AmountType remainingAmount;
    private String voucherID;

    /** 
     * Get the 'EffectiveDate' element value. Voucher Effective Date. Example: 2017-01-13
     * 
     * @return value
     */
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    /** 
     * Set the 'EffectiveDate' element value. Voucher Effective Date. Example: 2017-01-13
     * 
     * @param effectiveDate
     */
    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    /** 
     * Get the 'ExpirationDate' element value. Voucher Expiration date. Example: 2017-06-13
     * 
     * @return value
     */
    public Date getExpirationDate() {
        return expirationDate;
    }

    /** 
     * Set the 'ExpirationDate' element value. Voucher Expiration date. Example: 2017-06-13
     * 
     * @param expirationDate
     */
    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    /** 
     * Get the 'RemainingAmount' element value. Remaining Amount on Voucher.
     * 
     * @return value
     */
    public AmountType getRemainingAmount() {
        return remainingAmount;
    }

    /** 
     * Set the 'RemainingAmount' element value. Remaining Amount on Voucher.
     * 
     * @param remainingAmount
     */
    public void setRemainingAmount(AmountType remainingAmount) {
        this.remainingAmount = remainingAmount;
    }

    /** 
     * Get the 'VoucherID' element value. Voucher ID or Number. Example: XX12345
     * 
     * @return value
     */
    public String getVoucherID() {
        return voucherID;
    }

    /** 
     * Set the 'VoucherID' element value. Voucher ID or Number. Example: XX12345
     * 
     * @param voucherID
     */
    public void setVoucherID(String voucherID) {
        this.voucherID = voucherID;
    }
}
