
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * 
 A data type for 3DS Address Verification Action contextual list. Examples: 0 - Do not check AVS details with acquirer, but pass them through to ACS system only. 1 - Attempt AVS check. If the acquirer doesn't support AVS or AVS is unavailable, then the transaction will proceed as normal. If AVS is supported and the AVS check fails, then the transaction will be declined. 2 - The same as 1 except the transaction must be checked by AVS. If AVS isn't available, the transaction will be declined. 3 - AVS check will be attempted and any outcome will be recorded, but ignored i.e. transaction will not be declined if AVS fails or unavailable.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AVS_ActionSimpleType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="0"/>
 *     &lt;xs:enumeration value="1"/>
 *     &lt;xs:enumeration value="2"/>
 *     &lt;xs:enumeration value="3"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum AVSActionSimpleType implements Serializable {
    /** 
     * 
    0 - Do not check AVS details with acquirer, but pass them through to ACS system only.
    
     */
    _0("0"), /** 
              * 
                1 - Attempt AVS check. If the acquirer doesn't support AVS or AVS is unavailable, then the transaction will proceed as normal. If AVS is supported and the AVS check fails, then the transaction will be declined.
              
              */
    _1("1"), /** 
              * 
                2 - The same as 1 except the transaction must be checked by AVS. If AVS isn't available, the transaction will be declined.
              
              */
    _2("2"), /** 
              * 
                3 - AVS check will be attempted and any outcome will be recorded, but ignored, i.e. transaction will not be declined if AVS fails or unavailable
              
              */
    _3("3");
    private final String value;

    private AVSActionSimpleType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static AVSActionSimpleType convert(String value) {
        for (AVSActionSimpleType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
