
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * ACCEPTED PAYMENT FORM definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AcceptedPaymentFormType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:CodesetType" name="Type"/>
 *         &lt;xs:element type="ns:CurrencyAmountOptType" name="Amount" minOccurs="0"/>
 *         &lt;xs:element type="ns:CodesetType" name="Qualifier" minOccurs="0"/>
 *         &lt;xs:element ref="ns:Voucher" minOccurs="0"/>
 *         &lt;xs:element ref="ns:PaymentCard" minOccurs="0"/>
 *         &lt;xs:element ref="ns:Other" minOccurs="0"/>
 *         &lt;xs:element ref="ns:MiscChargeOrder" minOccurs="0"/>
 *         &lt;xs:element ref="ns:LoyaltyRedemption" minOccurs="0"/>
 *         &lt;xs:element ref="ns:DirectBill" minOccurs="0"/>
 *         &lt;xs:element ref="ns:Cash" minOccurs="0"/>
 *         &lt;xs:element ref="ns:BankAccount" minOccurs="0"/>
 *         &lt;xs:element ref="ns:Associations" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AcceptedPaymentFormType extends KeyWithMetaObjectBaseType
    implements Serializable
{
    private CodesetType type;
    private CurrencyAmountOptType amount;
    private CodesetType qualifier;
    private Voucher voucher;
    private PaymentCardType paymentCard;
    private Other other;
    private MiscChargeOrder miscChargeOrder;
    private LoyaltyRedemption loyaltyRedemption;
    private DirectBillType directBill;
    private Cash cash;
    private BankAccountType bankAccount;
    private Associations associations;

    /** 
     * Get the 'Type' element value. The form of payment type. Examples: Credit Card, Cash.

    Encoding Scheme: IATA PADIS code list data element [9888] Form of Payment Identification
     * 
     * @return value
     */
    public CodesetType getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value. The form of payment type. Examples: Credit Card, Cash.

    Encoding Scheme: IATA PADIS code list data element [9888] Form of Payment Identification
     * 
     * @param type
     */
    public void setType(CodesetType type) {
        this.type = type;
    }

    /** 
     * Get the 'Amount' element value. The amount for this form of payment. Example: 300 USD
     * 
     * @return value
     */
    public CurrencyAmountOptType getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. The amount for this form of payment. Example: 300 USD
     * 
     * @param amount
     */
    public void setAmount(CurrencyAmountOptType amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'Qualifier' element value. Used to specify if this is the old, new or orginal form of payment.

    Encoding Scheme: IATA  PADIS code list [9988] Data Indicator
     * 
     * @return value
     */
    public CodesetType getQualifier() {
        return qualifier;
    }

    /** 
     * Set the 'Qualifier' element value. Used to specify if this is the old, new or orginal form of payment.

    Encoding Scheme: IATA  PADIS code list [9988] Data Indicator
     * 
     * @param qualifier
     */
    public void setQualifier(CodesetType qualifier) {
        this.qualifier = qualifier;
    }

    /** 
     * Get the 'Voucher' element value. Information relating to prepayment vouchers.
     * 
     * @return value
     */
    public Voucher getVoucher() {
        return voucher;
    }

    /** 
     * Set the 'Voucher' element value. Information relating to prepayment vouchers.
     * 
     * @param voucher
     */
    public void setVoucher(Voucher voucher) {
        this.voucher = voucher;
    }

    /** 
     * Get the 'PaymentCard' element value.
     * 
     * @return value
     */
    public PaymentCardType getPaymentCard() {
        return paymentCard;
    }

    /** 
     * Set the 'PaymentCard' element value.
     * 
     * @param paymentCard
     */
    public void setPaymentCard(PaymentCardType paymentCard) {
        this.paymentCard = paymentCard;
    }

    /** 
     * Get the 'Other' element value.
     * 
     * @return value
     */
    public Other getOther() {
        return other;
    }

    /** 
     * Set the 'Other' element value.
     * 
     * @param other
     */
    public void setOther(Other other) {
        this.other = other;
    }

    /** 
     * Get the 'MiscChargeOrder' element value.
     * 
     * @return value
     */
    public MiscChargeOrder getMiscChargeOrder() {
        return miscChargeOrder;
    }

    /** 
     * Set the 'MiscChargeOrder' element value.
     * 
     * @param miscChargeOrder
     */
    public void setMiscChargeOrder(MiscChargeOrder miscChargeOrder) {
        this.miscChargeOrder = miscChargeOrder;
    }

    /** 
     * Get the 'LoyaltyRedemption' element value.
     * 
     * @return value
     */
    public LoyaltyRedemption getLoyaltyRedemption() {
        return loyaltyRedemption;
    }

    /** 
     * Set the 'LoyaltyRedemption' element value.
     * 
     * @param loyaltyRedemption
     */
    public void setLoyaltyRedemption(LoyaltyRedemption loyaltyRedemption) {
        this.loyaltyRedemption = loyaltyRedemption;
    }

    /** 
     * Get the 'DirectBill' element value.
     * 
     * @return value
     */
    public DirectBillType getDirectBill() {
        return directBill;
    }

    /** 
     * Set the 'DirectBill' element value.
     * 
     * @param directBill
     */
    public void setDirectBill(DirectBillType directBill) {
        this.directBill = directBill;
    }

    /** 
     * Get the 'Cash' element value.
     * 
     * @return value
     */
    public Cash getCash() {
        return cash;
    }

    /** 
     * Set the 'Cash' element value.
     * 
     * @param cash
     */
    public void setCash(Cash cash) {
        this.cash = cash;
    }

    /** 
     * Get the 'BankAccount' element value.
     * 
     * @return value
     */
    public BankAccountType getBankAccount() {
        return bankAccount;
    }

    /** 
     * Set the 'BankAccount' element value.
     * 
     * @param bankAccount
     */
    public void setBankAccount(BankAccountType bankAccount) {
        this.bankAccount = bankAccount;
    }

    /** 
     * Get the 'Associations' element value.
     * 
     * @return value
     */
    public Associations getAssociations() {
        return associations;
    }

    /** 
     * Set the 'Associations' element value.
     * 
     * @param associations
     */
    public void setAssociations(Associations associations) {
        this.associations = associations;
    }
}
