
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Agency Seller Type contextual list.
 Examples: TravelAgency, OnlineTravelAgency, TravelManagementCompany
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgencyCatListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="OnlineTravelAgency"/>
 *     &lt;xs:enumeration value="TravelAgency"/>
 *     &lt;xs:enumeration value="TravelManagementCompany"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum AgencyCatListType implements Serializable {
    ONLINE_TRAVEL_AGENCY("OnlineTravelAgency"), /** 
                                                 * Travel agency.
                                                 */
    TRAVEL_AGENCY("TravelAgency"), TRAVEL_MANAGEMENT_COMPANY(
            "TravelManagementCompany");
    private final String value;

    private AgencyCatListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static AgencyCatListType convert(String value) {
        for (AgencyCatListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
