
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for Core Agency (Seller) Group Representation.

 Notes:
 1. This type contains the common properties for all defined Agency Seller Role definitions, e.g. TravelAgency, Travel Agent.
 2. This type is derived from SellerCoreRepType.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgencyCoreRepType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:SellerCoreRepType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="OtherIDs" minOccurs="0">
 *           &lt;!-- Reference to inner class OtherIDs -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="PseudoCity" minOccurs="0">
 *           &lt;!-- Reference to inner class PseudoCity -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="xs:string" name="IATA_Number" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AgencyCoreRepType extends SellerCoreRepType implements
    Serializable
{
    private OtherIDs otherIDs;
    private PseudoCity pseudoCity;
    private String IATANumber;

    /** 
     * Get the 'OtherIDs' element value.
     * 
     * @return value
     */
    public OtherIDs getOtherIDs() {
        return otherIDs;
    }

    /** 
     * Set the 'OtherIDs' element value.
     * 
     * @param otherIDs
     */
    public void setOtherIDs(OtherIDs otherIDs) {
        this.otherIDs = otherIDs;
    }

    /** 
     * Get the 'PseudoCity' element value.
     * 
     * @return value
     */
    public PseudoCity getPseudoCity() {
        return pseudoCity;
    }

    /** 
     * Set the 'PseudoCity' element value.
     * 
     * @param pseudoCity
     */
    public void setPseudoCity(PseudoCity pseudoCity) {
        this.pseudoCity = pseudoCity;
    }

    /** 
     * Get the 'IATA_Number' element value. Agency Seller IATA number. Example: 98417900
     * 
     * @return value
     */
    public String getIATANumber() {
        return IATANumber;
    }

    /** 
     * Set the 'IATA_Number' element value. Agency Seller IATA number. Example: 98417900
     * 
     * @param IATANumber
     */
    public void setIATANumber(String IATANumber) {
        this.IATANumber = IATANumber;
    }
    /** 
     * Additional Agency (Seller) identification, such as federal tax IDs or registry entries.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherIDs" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="OtherID" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class OtherID -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OtherIDs implements Serializable
    {
        private List<OtherID> otherIDList = new ArrayList<OtherID>();

        /** 
         * Get the list of 'OtherID' element items.
         * 
         * @return list
         */
        public List<OtherID> getOtherIDList() {
            return otherIDList;
        }

        /** 
         * Set the list of 'OtherID' element items.
         * 
         * @param list
         */
        public void setOtherIDList(List<OtherID> list) {
            otherIDList = list;
        }
        /** 
         * Other identifier.  Examples: 13-015576, 50014517
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherID" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
         *         &lt;xs:attribute type="xs:string" use="optional" name="Description"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class OtherID implements Serializable
        {
            private String string;
            private String refs;
            private String description;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }

            /** 
             * Get the 'Description' attribute value. Other identification description. Examples: Federal Tax ID, TICO ID
             * 
             * @return value
             */
            public String getDescription() {
                return description;
            }

            /** 
             * Set the 'Description' attribute value. Other identification description. Examples: Federal Tax ID, TICO ID
             * 
             * @param description
             */
            public void setDescription(String description) {
                this.description = description;
            }
        }
    }
    /** 
     * Pseudo City code. Example: AAA2
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PseudoCity" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" name="Owner"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PseudoCity implements Serializable
    {
        private String string;
        private String owner;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'Owner' attribute value. Defines where the PCC was created. For example 1A, 1P, 1S
         * 
         * @return value
         */
        public String getOwner() {
            return owner;
        }

        /** 
         * Set the 'Owner' attribute value. Defines where the PCC was created. For example 1A, 1P, 1S
         * 
         * @param owner
         */
        public void setOwner(String owner) {
            this.owner = owner;
        }
    }
}
