
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for AGGREGATOR Intermediary Role, Core Representation.

 Notes:
 1. This is a representation of common (role-agnostic) properties associated with this Actor definition.
 2. This type is used as (derived) base type for all Roles associated with this Actor.
 3. This type is derived from IntermediaryCoreRepType.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AggregatorType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:IntermediaryCoreRepType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:RoleOfIntermediaryReference" minOccurs="0"/>
 *         &lt;xs:element ref="ns:AggregatorID"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:attribute type="xs:string" use="optional" name="ConnectMethod"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AggregatorType extends IntermediaryCoreRepType implements
    Serializable
{
    private RoleOfIntermediaryReferenceType roleOfIntermediaryReference;
    private AggregatorID aggregatorID;
    private String connectMethod;

    /** 
     * Get the 'RoleOfIntermediaryReference' element value.
     * 
     * @return value
     */
    public RoleOfIntermediaryReferenceType getRoleOfIntermediaryReference() {
        return roleOfIntermediaryReference;
    }

    /** 
     * Set the 'RoleOfIntermediaryReference' element value.
     * 
     * @param roleOfIntermediaryReference
     */
    public void setRoleOfIntermediaryReference(
            RoleOfIntermediaryReferenceType roleOfIntermediaryReference) {
        this.roleOfIntermediaryReference = roleOfIntermediaryReference;
    }

    /** 
     * Get the 'AggregatorID' element value.
     * 
     * @return value
     */
    public AggregatorID getAggregatorID() {
        return aggregatorID;
    }

    /** 
     * Set the 'AggregatorID' element value.
     * 
     * @param aggregatorID
     */
    public void setAggregatorID(AggregatorID aggregatorID) {
        this.aggregatorID = aggregatorID;
    }

    /** 
     * Get the 'ConnectMethod' attribute value. Connection Communication Method.  Examples: DirectWithAirline, DirectWithOther, Gateway
     * 
     * @return value
     */
    public String getConnectMethod() {
        return connectMethod;
    }

    /** 
     * Set the 'ConnectMethod' attribute value. Connection Communication Method.  Examples: DirectWithAirline, DirectWithOther, Gateway
     * 
     * @param connectMethod
     */
    public void setConnectMethod(String connectMethod) {
        this.connectMethod = connectMethod;
    }
}
