
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The AirDocVoid transaction set requests an Airline to void flight (ET) and/or ancillary (EMD) document(s).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirDocVoidRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:PointOfSale" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element name="Query">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element ref="ns:TicketDocQuantity"/>
 *             &lt;xs:element type="ns:TicketDocumentType" name="TicketDocument" maxOccurs="unbounded"/>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class AirDocVoidRQ implements Serializable
{
    private PointOfSaleType pointOfSale;
    private MsgDocumentType document;
    private MsgPartiesType party;
    private TicketDocQuantity queryTicketDocQuantity;
    private List<TicketDocumentType> queryTicketDocumentList = new ArrayList<TicketDocumentType>();
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'PointOfSale' element value.
     * 
     * @return value
     */
    public PointOfSaleType getPointOfSale() {
        return pointOfSale;
    }

    /** 
     * Set the 'PointOfSale' element value.
     * 
     * @param pointOfSale
     */
    public void setPointOfSale(PointOfSaleType pointOfSale) {
        this.pointOfSale = pointOfSale;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Get the 'TicketDocQuantity' element value.
     * 
     * @return value
     */
    public TicketDocQuantity getQueryTicketDocQuantity() {
        return queryTicketDocQuantity;
    }

    /** 
     * Set the 'TicketDocQuantity' element value.
     * 
     * @param queryTicketDocQuantity
     */
    public void setQueryTicketDocQuantity(
            TicketDocQuantity queryTicketDocQuantity) {
        this.queryTicketDocQuantity = queryTicketDocQuantity;
    }

    /** 
     * Get the list of 'TicketDocument' element items. The ticket/document to be voided.
     * 
     * @return list
     */
    public List<TicketDocumentType> getQueryTicketDocumentList() {
        return queryTicketDocumentList;
    }

    /** 
     * Set the list of 'TicketDocument' element items. The ticket/document to be voided.
     * 
     * @param list
     */
    public void setQueryTicketDocumentList(List<TicketDocumentType> list) {
        queryTicketDocumentList = list;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
}
