
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * AIR PASS CORE representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirPassCoreType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:AirlineID"/>
 *         &lt;xs:element name="Certificate" maxOccurs="unbounded">
 *           &lt;!-- Reference to inner class Certificate -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirPassCoreType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private AirlineIDType airlineID;
    private List<Certificate> certificateList = new ArrayList<Certificate>();

    /** 
     * Get the 'AirlineID' element value. Air Pass Program issuing airline designator code. Example: BA

    Encoding Scheme: IATA/ A4A (two to three character) Airline Designator Code
     * 
     * @return value
     */
    public AirlineIDType getAirlineID() {
        return airlineID;
    }

    /** 
     * Set the 'AirlineID' element value. Air Pass Program issuing airline designator code. Example: BA

    Encoding Scheme: IATA/ A4A (two to three character) Airline Designator Code
     * 
     * @param airlineID
     */
    public void setAirlineID(AirlineIDType airlineID) {
        this.airlineID = airlineID;
    }

    /** 
     * Get the list of 'Certificate' element items.
     * 
     * @return list
     */
    public List<Certificate> getCertificateList() {
        return certificateList;
    }

    /** 
     * Set the list of 'Certificate' element items.
     * 
     * @param list
     */
    public void setCertificateList(List<Certificate> list) {
        certificateList = list;
    }
    /** 
     * Airr Pass Certificate information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Certificate" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:AssociatedObjectBaseType">
     *         &lt;xs:sequence>
     *           &lt;xs:element name="Number">
     *             &lt;xs:complexType>
     *               &lt;xs:simpleContent>
     *                 &lt;xs:extension base="xs:string">
     *                   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *                 &lt;/xs:extension>
     *               &lt;/xs:simpleContent>
     *             &lt;/xs:complexType>
     *           &lt;/xs:element>
     *           &lt;xs:element type="xs:string" name="Application" minOccurs="0"/>
     *           &lt;xs:element name="EffectivePeriod" minOccurs="0">
     *             &lt;!-- Reference to inner class EffectivePeriod -->
     *           &lt;/xs:element>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Certificate extends AssociatedObjectBaseType implements
        Serializable
    {
        private String numberString;
        private String numberRefs;
        private String application;
        private EffectivePeriod effectivePeriod;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getNumberString() {
            return numberString;
        }

        /** 
         * Set the extension value.
         * 
         * @param numberString
         */
        public void setNumberString(String numberString) {
            this.numberString = numberString;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getNumberRefs() {
            return numberRefs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param numberRefs
         */
        public void setNumberRefs(String numberRefs) {
            this.numberRefs = numberRefs;
        }

        /** 
         * Get the 'Application' element value. Certificate Application.  Example: Redemption
         * 
         * @return value
         */
        public String getApplication() {
            return application;
        }

        /** 
         * Set the 'Application' element value. Certificate Application.  Example: Redemption
         * 
         * @param application
         */
        public void setApplication(String application) {
            this.application = application;
        }

        /** 
         * Get the 'EffectivePeriod' element value.
         * 
         * @return value
         */
        public EffectivePeriod getEffectivePeriod() {
            return effectivePeriod;
        }

        /** 
         * Set the 'EffectivePeriod' element value.
         * 
         * @param effectivePeriod
         */
        public void setEffectivePeriod(EffectivePeriod effectivePeriod) {
            this.effectivePeriod = effectivePeriod;
        }
        /** 
         * Certificate Effective/ Expiration Period.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EffectivePeriod" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element ref="ns:YearPeriod"/>
         *       &lt;xs:element ref="ns:YearMonthPeriod"/>
         *       &lt;xs:element ref="ns:TimePeriod"/>
         *       &lt;xs:element ref="ns:QuarterPeriod"/>
         *       &lt;xs:element ref="ns:MonthPeriod"/>
         *       &lt;xs:element ref="ns:DayPeriod"/>
         *       &lt;xs:element ref="ns:DateTimePeriod"/>
         *       &lt;xs:element ref="ns:DatePeriod"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class EffectivePeriod implements Serializable
        {
            private YearPeriodRepType yearPeriod;
            private YearMonthPeriodRepType yearMonthPeriod;
            private TimePeriodRepType timePeriod;
            private QuarterPeriodRepType quarterPeriod;
            private MonthPeriodRepType monthPeriod;
            private DayPeriodRepType dayPeriod;
            private DateTimePeriodRepType dateTimePeriod;
            private DatePeriodRepType datePeriod;

            /** 
             * Get the 'YearPeriod' element value.
             * 
             * @return value
             */
            public YearPeriodRepType getYearPeriod() {
                return yearPeriod;
            }

            /** 
             * Set the 'YearPeriod' element value.
             * 
             * @param yearPeriod
             */
            public void setYearPeriod(YearPeriodRepType yearPeriod) {
                this.yearPeriod = yearPeriod;
            }

            /** 
             * Get the 'YearMonthPeriod' element value.
             * 
             * @return value
             */
            public YearMonthPeriodRepType getYearMonthPeriod() {
                return yearMonthPeriod;
            }

            /** 
             * Set the 'YearMonthPeriod' element value.
             * 
             * @param yearMonthPeriod
             */
            public void setYearMonthPeriod(
                    YearMonthPeriodRepType yearMonthPeriod) {
                this.yearMonthPeriod = yearMonthPeriod;
            }

            /** 
             * Get the 'TimePeriod' element value.
             * 
             * @return value
             */
            public TimePeriodRepType getTimePeriod() {
                return timePeriod;
            }

            /** 
             * Set the 'TimePeriod' element value.
             * 
             * @param timePeriod
             */
            public void setTimePeriod(TimePeriodRepType timePeriod) {
                this.timePeriod = timePeriod;
            }

            /** 
             * Get the 'QuarterPeriod' element value.
             * 
             * @return value
             */
            public QuarterPeriodRepType getQuarterPeriod() {
                return quarterPeriod;
            }

            /** 
             * Set the 'QuarterPeriod' element value.
             * 
             * @param quarterPeriod
             */
            public void setQuarterPeriod(QuarterPeriodRepType quarterPeriod) {
                this.quarterPeriod = quarterPeriod;
            }

            /** 
             * Get the 'MonthPeriod' element value.
             * 
             * @return value
             */
            public MonthPeriodRepType getMonthPeriod() {
                return monthPeriod;
            }

            /** 
             * Set the 'MonthPeriod' element value.
             * 
             * @param monthPeriod
             */
            public void setMonthPeriod(MonthPeriodRepType monthPeriod) {
                this.monthPeriod = monthPeriod;
            }

            /** 
             * Get the 'DayPeriod' element value.
             * 
             * @return value
             */
            public DayPeriodRepType getDayPeriod() {
                return dayPeriod;
            }

            /** 
             * Set the 'DayPeriod' element value.
             * 
             * @param dayPeriod
             */
            public void setDayPeriod(DayPeriodRepType dayPeriod) {
                this.dayPeriod = dayPeriod;
            }

            /** 
             * Get the 'DateTimePeriod' element value.
             * 
             * @return value
             */
            public DateTimePeriodRepType getDateTimePeriod() {
                return dateTimePeriod;
            }

            /** 
             * Set the 'DateTimePeriod' element value.
             * 
             * @param dateTimePeriod
             */
            public void setDateTimePeriod(DateTimePeriodRepType dateTimePeriod) {
                this.dateTimePeriod = dateTimePeriod;
            }

            /** 
             * Get the 'DatePeriod' element value.
             * 
             * @return value
             */
            public DatePeriodRepType getDatePeriod() {
                return datePeriod;
            }

            /** 
             * Set the 'DatePeriod' element value.
             * 
             * @param datePeriod
             */
            public void setDatePeriod(DatePeriodRepType datePeriod) {
                this.datePeriod = datePeriod;
            }
        }
    }
}
