
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * AIR PASS DETAIL representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirPassDetailType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AirPassCoreType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="ProgramName"/>
 *         &lt;xs:element type="xs:string" name="ProgramCode" minOccurs="0"/>
 *         &lt;xs:element name="Holder" minOccurs="0">
 *           &lt;!-- Reference to inner class Holder -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirPassDetailType extends AirPassCoreType implements Serializable
{
    private String programName;
    private String programCode;
    private Holder holder;

    /** 
     * Get the 'ProgramName' element value. Program Name. Example: PASSPRO
     * 
     * @return value
     */
    public String getProgramName() {
        return programName;
    }

    /** 
     * Set the 'ProgramName' element value. Program Name. Example: PASSPRO
     * 
     * @param programName
     */
    public void setProgramName(String programName) {
        this.programName = programName;
    }

    /** 
     * Get the 'ProgramCode' element value. Program Code. Example: PP01
     * 
     * @return value
     */
    public String getProgramCode() {
        return programCode;
    }

    /** 
     * Set the 'ProgramCode' element value. Program Code. Example: PP01
     * 
     * @param programCode
     */
    public void setProgramCode(String programCode) {
        this.programCode = programCode;
    }

    /** 
     * Get the 'Holder' element value.
     * 
     * @return value
     */
    public Holder getHolder() {
        return holder;
    }

    /** 
     * Set the 'Holder' element value.
     * 
     * @param holder
     */
    public void setHolder(Holder holder) {
        this.holder = holder;
    }
    /** 
     * Agency or Corporate Certificate holder or program owner information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Holder" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element ref="ns:AgencyID"/>
     *       &lt;xs:element ref="ns:PartnerID"/>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Holder implements Serializable
    {
        private int holderSelect = -1;
        private static final int AGENCY_ID_CHOICE = 0;
        private static final int PARTNER_ID_CHOICE = 1;
        private AgencyID agencyID;
        private PartnerCompanyIDType partnerID;

        private void setHolderSelect(int choice) {
            if (holderSelect == -1) {
                holderSelect = choice;
            } else if (holderSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearHolderSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearHolderSelect() {
            holderSelect = -1;
        }

        /** 
         * Check if AgencyID is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAgencyID() {
            return holderSelect == AGENCY_ID_CHOICE;
        }

        /** 
         * Get the 'AgencyID' element value.
         * 
         * @return value
         */
        public AgencyID getAgencyID() {
            return agencyID;
        }

        /** 
         * Set the 'AgencyID' element value.
         * 
         * @param agencyID
         */
        public void setAgencyID(AgencyID agencyID) {
            setHolderSelect(AGENCY_ID_CHOICE);
            this.agencyID = agencyID;
        }

        /** 
         * Check if PartnerID is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPartnerID() {
            return holderSelect == PARTNER_ID_CHOICE;
        }

        /** 
         * Get the 'PartnerID' element value.
         * 
         * @return value
         */
        public PartnerCompanyIDType getPartnerID() {
            return partnerID;
        }

        /** 
         * Set the 'PartnerID' element value.
         * 
         * @param partnerID
         */
        public void setPartnerID(PartnerCompanyIDType partnerID) {
            setHolderSelect(PARTNER_ID_CHOICE);
            this.partnerID = partnerID;
        }
    }
}
