
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * AirShopReq Business Object: FLIGHT SPECIFIC definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirShopFlightSpecificType">
 *   &lt;xs:choice>
 *     &lt;xs:element name="FlightSegment" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class FlightSegment -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Flight" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Flight -->
 *     &lt;/xs:element>
 *     &lt;xs:element ref="ns:OriginDestination" maxOccurs="unbounded"/>
 *     &lt;xs:element ref="ns:ShoppingResponseIDs" minOccurs="0"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirShopFlightSpecificType implements Serializable
{
    private int choiceSelect = -1;
    private static final int FLIGHT_SEGMENT_LIST_CHOICE = 0;
    private static final int FLIGHT_LIST_CHOICE = 1;
    private static final int ORIGIN_DESTINATION_LIST_CHOICE = 2;
    private static final int SHOPPING_RESPONSE_I_DS_CHOICE = 3;
    private List<FlightSegment> flightSegmentList = new ArrayList<FlightSegment>();
    private List<Flight> flightList = new ArrayList<Flight>();
    private List<OriginDestination> originDestinationList = new ArrayList<OriginDestination>();
    private ShoppingResponseIDType shoppingResponseIDs;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if FlightSegmentList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFlightSegmentList() {
        return choiceSelect == FLIGHT_SEGMENT_LIST_CHOICE;
    }

    /** 
     * Get the list of 'FlightSegment' element items.
     * 
     * @return list
     */
    public List<FlightSegment> getFlightSegmentList() {
        return flightSegmentList;
    }

    /** 
     * Set the list of 'FlightSegment' element items.
     * 
     * @param list
     */
    public void setFlightSegmentList(List<FlightSegment> list) {
        setChoiceSelect(FLIGHT_SEGMENT_LIST_CHOICE);
        flightSegmentList = list;
    }

    /** 
     * Check if FlightList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFlightList() {
        return choiceSelect == FLIGHT_LIST_CHOICE;
    }

    /** 
     * Get the list of 'Flight' element items.
     * 
     * @return list
     */
    public List<Flight> getFlightList() {
        return flightList;
    }

    /** 
     * Set the list of 'Flight' element items.
     * 
     * @param list
     */
    public void setFlightList(List<Flight> list) {
        setChoiceSelect(FLIGHT_LIST_CHOICE);
        flightList = list;
    }

    /** 
     * Check if OriginDestinationList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOriginDestinationList() {
        return choiceSelect == ORIGIN_DESTINATION_LIST_CHOICE;
    }

    /** 
     * Get the list of 'OriginDestination' element items.
     * 
     * @return list
     */
    public List<OriginDestination> getOriginDestinationList() {
        return originDestinationList;
    }

    /** 
     * Set the list of 'OriginDestination' element items.
     * 
     * @param list
     */
    public void setOriginDestinationList(List<OriginDestination> list) {
        setChoiceSelect(ORIGIN_DESTINATION_LIST_CHOICE);
        originDestinationList = list;
    }

    /** 
     * Check if ShoppingResponseIDs is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifShoppingResponseIDs() {
        return choiceSelect == SHOPPING_RESPONSE_I_DS_CHOICE;
    }

    /** 
     * Get the 'ShoppingResponseIDs' element value.
     * 
     * @return value
     */
    public ShoppingResponseIDType getShoppingResponseIDs() {
        return shoppingResponseIDs;
    }

    /** 
     * Set the 'ShoppingResponseIDs' element value.
     * 
     * @param shoppingResponseIDs
     */
    public void setShoppingResponseIDs(
            ShoppingResponseIDType shoppingResponseIDs) {
        setChoiceSelect(SHOPPING_RESPONSE_I_DS_CHOICE);
        this.shoppingResponseIDs = shoppingResponseIDs;
    }
    /** 
     * FlighSegment information. Contains details flight segment information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegment" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:Departure"/>
     *       &lt;xs:element ref="ns:Arrival"/>
     *       &lt;xs:element type="ns:MarketingCarrierFlightType" name="MarketingAirline"/>
     *       &lt;xs:element type="ns:OperatingCarrierFlightType" name="OperatingAirline" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:int" use="required" name="SegmentKey"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FlightSegment implements Serializable
    {
        private FlightDepartureType departure;
        private FlightArrivalType arrival;
        private MarketingCarrierFlightType marketingAirline;
        private OperatingCarrierFlightType operatingAirline;
        private Integer segmentKey;

        /** 
         * Get the 'Departure' element value.
         * 
         * @return value
         */
        public FlightDepartureType getDeparture() {
            return departure;
        }

        /** 
         * Set the 'Departure' element value.
         * 
         * @param departure
         */
        public void setDeparture(FlightDepartureType departure) {
            this.departure = departure;
        }

        /** 
         * Get the 'Arrival' element value.
         * 
         * @return value
         */
        public FlightArrivalType getArrival() {
            return arrival;
        }

        /** 
         * Set the 'Arrival' element value.
         * 
         * @param arrival
         */
        public void setArrival(FlightArrivalType arrival) {
            this.arrival = arrival;
        }

        /** 
         * Get the 'MarketingAirline' element value. Marketing Carrier information.
         * 
         * @return value
         */
        public MarketingCarrierFlightType getMarketingAirline() {
            return marketingAirline;
        }

        /** 
         * Set the 'MarketingAirline' element value. Marketing Carrier information.
         * 
         * @param marketingAirline
         */
        public void setMarketingAirline(
                MarketingCarrierFlightType marketingAirline) {
            this.marketingAirline = marketingAirline;
        }

        /** 
         * Get the 'OperatingAirline' element value. Operating Carrier information.

        Note: This is the carrier that holds the Air Operator’s Certificate for the aircraft used for that flight.
         * 
         * @return value
         */
        public OperatingCarrierFlightType getOperatingAirline() {
            return operatingAirline;
        }

        /** 
         * Set the 'OperatingAirline' element value. Operating Carrier information.

        Note: This is the carrier that holds the Air Operator’s Certificate for the aircraft used for that flight.
         * 
         * @param operatingAirline
         */
        public void setOperatingAirline(
                OperatingCarrierFlightType operatingAirline) {
            this.operatingAirline = operatingAirline;
        }

        /** 
         * Get the 'SegmentKey' attribute value. A globally unique identifier for this Flight Segment instance. Example: segment1
         * 
         * @return value
         */
        public Integer getSegmentKey() {
            return segmentKey;
        }

        /** 
         * Set the 'SegmentKey' attribute value. A globally unique identifier for this Flight Segment instance. Example: segment1
         * 
         * @param segmentKey
         */
        public void setSegmentKey(Integer segmentKey) {
            this.segmentKey = segmentKey;
        }
    }
    /** 
     * Flight information. Flight can be made of one to multiple FlightSegment elements. For example Flight can be made of flight segment BA123 and BA34.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Flight" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:TotalJourneyType" name="Journey" minOccurs="0"/>
     *       &lt;xs:element ref="ns:SegmentReferences"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *     &lt;xs:attribute type="xs:string" name="FlightKey"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Flight implements Serializable
    {
        private TotalJourneyType journey;
        private SegmentReferences segmentReferences;
        private String refs;
        private String flightKey;

        /** 
         * Get the 'Journey' element value. Flight journey information.
         * 
         * @return value
         */
        public TotalJourneyType getJourney() {
            return journey;
        }

        /** 
         * Set the 'Journey' element value. Flight journey information.
         * 
         * @param journey
         */
        public void setJourney(TotalJourneyType journey) {
            this.journey = journey;
        }

        /** 
         * Get the 'SegmentReferences' element value.
         * 
         * @return value
         */
        public SegmentReferences getSegmentReferences() {
            return segmentReferences;
        }

        /** 
         * Set the 'SegmentReferences' element value.
         * 
         * @param segmentReferences
         */
        public void setSegmentReferences(SegmentReferences segmentReferences) {
            this.segmentReferences = segmentReferences;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }

        /** 
         * Get the 'FlightKey' attribute value. A globally unique identifier for this Flight instance. Example: flight1
         * 
         * @return value
         */
        public String getFlightKey() {
            return flightKey;
        }

        /** 
         * Set the 'FlightKey' attribute value. A globally unique identifier for this Flight instance. Example: flight1
         * 
         * @param flightKey
         */
        public void setFlightKey(String flightKey) {
            this.flightKey = flightKey;
        }
    }
}
