
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * AirShopReq Business Object: AFFINITY QUERY definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirShopReqAffinityQueryType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="OriginDestination" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class OriginDestination -->
 *     &lt;/xs:element>
 *     &lt;xs:element ref="ns:StayPeriodDateRange" minOccurs="0"/>
 *     &lt;xs:element ref="ns:StayPeriodSeason" minOccurs="0"/>
 *     &lt;xs:element ref="ns:TripDistance" minOccurs="0"/>
 *     &lt;xs:element ref="ns:TripTime" minOccurs="0"/>
 *     &lt;xs:element name="Budget" minOccurs="0">
 *       &lt;!-- Reference to inner class Budget -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="KeywordPreferences" minOccurs="0">
 *       &lt;!-- Reference to inner class KeywordPreferences -->
 *     &lt;/xs:element>
 *     &lt;xs:element ref="ns:ShoppingResponseIDs" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirShopReqAffinityQueryType implements Serializable
{
    private List<OriginDestination> originDestinationList = new ArrayList<OriginDestination>();
    private StayPeriodDateRangeType stayPeriodDateRange;
    private StayPeriodSeasonType stayPeriodSeason;
    private TravelDistancePreferencesType tripDistance;
    private TravelTimePreferencesType tripTime;
    private Budget budget;
    private KeywordPreferences keywordPreferences;
    private ShoppingResponseIDType shoppingResponseIDs;

    /** 
     * Get the list of 'OriginDestination' element items.
     * 
     * @return list
     */
    public List<OriginDestination> getOriginDestinationList() {
        return originDestinationList;
    }

    /** 
     * Set the list of 'OriginDestination' element items.
     * 
     * @param list
     */
    public void setOriginDestinationList(List<OriginDestination> list) {
        originDestinationList = list;
    }

    /** 
     * Get the 'StayPeriodDateRange' element value.
     * 
     * @return value
     */
    public StayPeriodDateRangeType getStayPeriodDateRange() {
        return stayPeriodDateRange;
    }

    /** 
     * Set the 'StayPeriodDateRange' element value.
     * 
     * @param stayPeriodDateRange
     */
    public void setStayPeriodDateRange(
            StayPeriodDateRangeType stayPeriodDateRange) {
        this.stayPeriodDateRange = stayPeriodDateRange;
    }

    /** 
     * Get the 'StayPeriodSeason' element value.
     * 
     * @return value
     */
    public StayPeriodSeasonType getStayPeriodSeason() {
        return stayPeriodSeason;
    }

    /** 
     * Set the 'StayPeriodSeason' element value.
     * 
     * @param stayPeriodSeason
     */
    public void setStayPeriodSeason(StayPeriodSeasonType stayPeriodSeason) {
        this.stayPeriodSeason = stayPeriodSeason;
    }

    /** 
     * Get the 'TripDistance' element value.
     * 
     * @return value
     */
    public TravelDistancePreferencesType getTripDistance() {
        return tripDistance;
    }

    /** 
     * Set the 'TripDistance' element value.
     * 
     * @param tripDistance
     */
    public void setTripDistance(TravelDistancePreferencesType tripDistance) {
        this.tripDistance = tripDistance;
    }

    /** 
     * Get the 'TripTime' element value.
     * 
     * @return value
     */
    public TravelTimePreferencesType getTripTime() {
        return tripTime;
    }

    /** 
     * Set the 'TripTime' element value.
     * 
     * @param tripTime
     */
    public void setTripTime(TravelTimePreferencesType tripTime) {
        this.tripTime = tripTime;
    }

    /** 
     * Get the 'Budget' element value.
     * 
     * @return value
     */
    public Budget getBudget() {
        return budget;
    }

    /** 
     * Set the 'Budget' element value.
     * 
     * @param budget
     */
    public void setBudget(Budget budget) {
        this.budget = budget;
    }

    /** 
     * Get the 'KeywordPreferences' element value.
     * 
     * @return value
     */
    public KeywordPreferences getKeywordPreferences() {
        return keywordPreferences;
    }

    /** 
     * Set the 'KeywordPreferences' element value.
     * 
     * @param keywordPreferences
     */
    public void setKeywordPreferences(KeywordPreferences keywordPreferences) {
        this.keywordPreferences = keywordPreferences;
    }

    /** 
     * Get the 'ShoppingResponseIDs' element value.
     * 
     * @return value
     */
    public ShoppingResponseIDType getShoppingResponseIDs() {
        return shoppingResponseIDs;
    }

    /** 
     * Set the 'ShoppingResponseIDs' element value.
     * 
     * @param shoppingResponseIDs
     */
    public void setShoppingResponseIDs(
            ShoppingResponseIDType shoppingResponseIDs) {
        this.shoppingResponseIDs = shoppingResponseIDs;
    }
    /** 
     * Flight origin/ destination information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestination" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:AssociatedObjectBaseType">
     *         &lt;xs:sequence>
     *           &lt;xs:element ref="ns:AirportCityDeparture" minOccurs="0"/>
     *           &lt;xs:element ref="ns:CountryDeparture" minOccurs="0"/>
     *           &lt;xs:element ref="ns:ReferencePointDeparture" minOccurs="0"/>
     *           &lt;xs:element ref="ns:StateProvDeparture" minOccurs="0"/>
     *           &lt;xs:element ref="ns:AirportCityArrival" minOccurs="0"/>
     *           &lt;xs:element ref="ns:CountryArrival" minOccurs="0"/>
     *           &lt;xs:element ref="ns:ReferencePointArrival" minOccurs="0"/>
     *           &lt;xs:element ref="ns:StateProvArrival" minOccurs="0"/>
     *           &lt;xs:element ref="ns:SegMaxTimePreferences" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OriginDestination extends AssociatedObjectBaseType
        implements Serializable
    {
        private FltDepartQualifiedQueryType airportCityDeparture;
        private AffinityCountryDepartType countryDeparture;
        private AffinityReferencePointDepartType referencePointDeparture;
        private AffinityStateProvDepartType stateProvDeparture;
        private FltArriveQualifiedQueryType airportCityArrival;
        private AffinityCountryArriveType countryArrival;
        private AffinityReferencePointArriveType referencePointArrival;
        private AffinityStateProvArriveType stateProvArrival;
        private FltSegmentMaxTimePreferencesType segMaxTimePreferences;

        /** 
         * Get the 'AirportCityDeparture' element value.
         * 
         * @return value
         */
        public FltDepartQualifiedQueryType getAirportCityDeparture() {
            return airportCityDeparture;
        }

        /** 
         * Set the 'AirportCityDeparture' element value.
         * 
         * @param airportCityDeparture
         */
        public void setAirportCityDeparture(
                FltDepartQualifiedQueryType airportCityDeparture) {
            this.airportCityDeparture = airportCityDeparture;
        }

        /** 
         * Get the 'CountryDeparture' element value.
         * 
         * @return value
         */
        public AffinityCountryDepartType getCountryDeparture() {
            return countryDeparture;
        }

        /** 
         * Set the 'CountryDeparture' element value.
         * 
         * @param countryDeparture
         */
        public void setCountryDeparture(
                AffinityCountryDepartType countryDeparture) {
            this.countryDeparture = countryDeparture;
        }

        /** 
         * Get the 'ReferencePointDeparture' element value.
         * 
         * @return value
         */
        public AffinityReferencePointDepartType getReferencePointDeparture() {
            return referencePointDeparture;
        }

        /** 
         * Set the 'ReferencePointDeparture' element value.
         * 
         * @param referencePointDeparture
         */
        public void setReferencePointDeparture(
                AffinityReferencePointDepartType referencePointDeparture) {
            this.referencePointDeparture = referencePointDeparture;
        }

        /** 
         * Get the 'StateProvDeparture' element value.
         * 
         * @return value
         */
        public AffinityStateProvDepartType getStateProvDeparture() {
            return stateProvDeparture;
        }

        /** 
         * Set the 'StateProvDeparture' element value.
         * 
         * @param stateProvDeparture
         */
        public void setStateProvDeparture(
                AffinityStateProvDepartType stateProvDeparture) {
            this.stateProvDeparture = stateProvDeparture;
        }

        /** 
         * Get the 'AirportCityArrival' element value.
         * 
         * @return value
         */
        public FltArriveQualifiedQueryType getAirportCityArrival() {
            return airportCityArrival;
        }

        /** 
         * Set the 'AirportCityArrival' element value.
         * 
         * @param airportCityArrival
         */
        public void setAirportCityArrival(
                FltArriveQualifiedQueryType airportCityArrival) {
            this.airportCityArrival = airportCityArrival;
        }

        /** 
         * Get the 'CountryArrival' element value.
         * 
         * @return value
         */
        public AffinityCountryArriveType getCountryArrival() {
            return countryArrival;
        }

        /** 
         * Set the 'CountryArrival' element value.
         * 
         * @param countryArrival
         */
        public void setCountryArrival(AffinityCountryArriveType countryArrival) {
            this.countryArrival = countryArrival;
        }

        /** 
         * Get the 'ReferencePointArrival' element value.
         * 
         * @return value
         */
        public AffinityReferencePointArriveType getReferencePointArrival() {
            return referencePointArrival;
        }

        /** 
         * Set the 'ReferencePointArrival' element value.
         * 
         * @param referencePointArrival
         */
        public void setReferencePointArrival(
                AffinityReferencePointArriveType referencePointArrival) {
            this.referencePointArrival = referencePointArrival;
        }

        /** 
         * Get the 'StateProvArrival' element value.
         * 
         * @return value
         */
        public AffinityStateProvArriveType getStateProvArrival() {
            return stateProvArrival;
        }

        /** 
         * Set the 'StateProvArrival' element value.
         * 
         * @param stateProvArrival
         */
        public void setStateProvArrival(
                AffinityStateProvArriveType stateProvArrival) {
            this.stateProvArrival = stateProvArrival;
        }

        /** 
         * Get the 'SegMaxTimePreferences' element value.
         * 
         * @return value
         */
        public FltSegmentMaxTimePreferencesType getSegMaxTimePreferences() {
            return segMaxTimePreferences;
        }

        /** 
         * Set the 'SegMaxTimePreferences' element value.
         * 
         * @param segMaxTimePreferences
         */
        public void setSegMaxTimePreferences(
                FltSegmentMaxTimePreferencesType segMaxTimePreferences) {
            this.segMaxTimePreferences = segMaxTimePreferences;
        }
    }
    /** 
     * Trip Budget.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Budget" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element ref="ns:GroupBudget"/>
     *       &lt;xs:element ref="ns:PerPersonBudget"/>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Budget implements Serializable
    {
        private int budgetSelect = -1;
        private static final int GROUP_BUDGET_CHOICE = 0;
        private static final int PER_PERSON_BUDGET_CHOICE = 1;
        private GroupBudgetType groupBudget;
        private PersonBudgetType perPersonBudget;

        private void setBudgetSelect(int choice) {
            if (budgetSelect == -1) {
                budgetSelect = choice;
            } else if (budgetSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearBudgetSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearBudgetSelect() {
            budgetSelect = -1;
        }

        /** 
         * Check if GroupBudget is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifGroupBudget() {
            return budgetSelect == GROUP_BUDGET_CHOICE;
        }

        /** 
         * Get the 'GroupBudget' element value.
         * 
         * @return value
         */
        public GroupBudgetType getGroupBudget() {
            return groupBudget;
        }

        /** 
         * Set the 'GroupBudget' element value.
         * 
         * @param groupBudget
         */
        public void setGroupBudget(GroupBudgetType groupBudget) {
            setBudgetSelect(GROUP_BUDGET_CHOICE);
            this.groupBudget = groupBudget;
        }

        /** 
         * Check if PerPersonBudget is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPerPersonBudget() {
            return budgetSelect == PER_PERSON_BUDGET_CHOICE;
        }

        /** 
         * Get the 'PerPersonBudget' element value.
         * 
         * @return value
         */
        public PersonBudgetType getPerPersonBudget() {
            return perPersonBudget;
        }

        /** 
         * Set the 'PerPersonBudget' element value.
         * 
         * @param perPersonBudget
         */
        public void setPerPersonBudget(PersonBudgetType perPersonBudget) {
            setBudgetSelect(PER_PERSON_BUDGET_CHOICE);
            this.perPersonBudget = perPersonBudget;
        }
    }
    /** 
     * Affinity Query Keyword(s) with optional preference level.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="KeywordPreferences" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="KeywordPreference" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class KeywordPreference -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class KeywordPreferences implements Serializable
    {
        private List<KeywordPreference> keywordPreferenceList = new ArrayList<KeywordPreference>();

        /** 
         * Get the list of 'KeywordPreference' element items.
         * 
         * @return list
         */
        public List<KeywordPreference> getKeywordPreferenceList() {
            return keywordPreferenceList;
        }

        /** 
         * Set the list of 'KeywordPreference' element items.
         * 
         * @param list
         */
        public void setKeywordPreferenceList(List<KeywordPreference> list) {
            keywordPreferenceList = list;
        }
        /** 
         * Keyword/ Value Search Criteria.

        Note: Keyword-Value pairs may be used to specify a variety of affinity qualifiers, such as Climate, Activity, and Point of Interest.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="KeywordPreference" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:KeyWordType">
         *         &lt;xs:attributeGroup ref="ns:PreferenceAttrGroup"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class KeywordPreference extends KeyWordType implements
            Serializable
        {
            private PreferenceAttrGroup preferenceAttrGroup;

            /** 
             * Get the 'PreferenceAttrGroup' attributeGroup value.
             * 
             * @return value
             */
            public PreferenceAttrGroup getPreferenceAttrGroup() {
                return preferenceAttrGroup;
            }

            /** 
             * Set the 'PreferenceAttrGroup' attributeGroup value.
             * 
             * @param preferenceAttrGroup
             */
            public void setPreferenceAttrGroup(
                    PreferenceAttrGroup preferenceAttrGroup) {
                this.preferenceAttrGroup = preferenceAttrGroup;
            }
        }
    }
}
