
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for AirShopReq Business Object: ATTRIBUTE QUERY definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirShopReqAttributeQueryType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="OriginDestination" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class OriginDestination -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirShopReqAttributeQueryType implements Serializable
{
    private List<OriginDestination> originDestinationList = new ArrayList<OriginDestination>();

    /** 
     * Get the list of 'OriginDestination' element items.
     * 
     * @return list
     */
    public List<OriginDestination> getOriginDestinationList() {
        return originDestinationList;
    }

    /** 
     * Set the list of 'OriginDestination' element items.
     * 
     * @param list
     */
    public void setOriginDestinationList(List<OriginDestination> list) {
        originDestinationList = list;
    }
    /** 
     * Flight origin/ destination information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestination" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:AssociatedObjectBaseType">
     *         &lt;xs:sequence>
     *           &lt;xs:element ref="ns:Departure"/>
     *           &lt;xs:element ref="ns:Arrival"/>
     *           &lt;xs:element ref="ns:SegMaxTimePreferences" minOccurs="0"/>
     *           &lt;xs:element ref="ns:ShoppingResponseIDs" minOccurs="0"/>
     *           &lt;xs:element ref="ns:MarketingCarrierAirline" minOccurs="0"/>
     *           &lt;xs:element name="CalendarDates" minOccurs="0">
     *             &lt;!-- Reference to inner class CalendarDates -->
     *           &lt;/xs:element>
     *         &lt;/xs:sequence>
     *         &lt;xs:attribute type="xs:anySimpleType" name="OriginDestinationKey"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OriginDestination extends AssociatedObjectBaseType
        implements Serializable
    {
        private FlightDepartureType departure;
        private FlightArrivalType arrival;
        private FltSegmentMaxTimePreferencesType segMaxTimePreferences;
        private ShoppingResponseIDType shoppingResponseIDs;
        private MarketingCarrierType marketingCarrierAirline;
        private CalendarDates calendarDates;
        private String originDestinationKey;

        /** 
         * Get the 'Departure' element value. FLIGHT DEPARTURE (ORIGIN).
         * 
         * @return value
         */
        public FlightDepartureType getDeparture() {
            return departure;
        }

        /** 
         * Set the 'Departure' element value. FLIGHT DEPARTURE (ORIGIN).
         * 
         * @param departure
         */
        public void setDeparture(FlightDepartureType departure) {
            this.departure = departure;
        }

        /** 
         * Get the 'Arrival' element value. FLIGHT ARRIVAL (DESTINATION).
         * 
         * @return value
         */
        public FlightArrivalType getArrival() {
            return arrival;
        }

        /** 
         * Set the 'Arrival' element value. FLIGHT ARRIVAL (DESTINATION).
         * 
         * @param arrival
         */
        public void setArrival(FlightArrivalType arrival) {
            this.arrival = arrival;
        }

        /** 
         * Get the 'SegMaxTimePreferences' element value.
         * 
         * @return value
         */
        public FltSegmentMaxTimePreferencesType getSegMaxTimePreferences() {
            return segMaxTimePreferences;
        }

        /** 
         * Set the 'SegMaxTimePreferences' element value.
         * 
         * @param segMaxTimePreferences
         */
        public void setSegMaxTimePreferences(
                FltSegmentMaxTimePreferencesType segMaxTimePreferences) {
            this.segMaxTimePreferences = segMaxTimePreferences;
        }

        /** 
         * Get the 'ShoppingResponseIDs' element value. Flight-related shopping response IDs, including the unique (master) Shopping Session ID, Offer IDs, Offer Item IDs and Service IDs.
         * 
         * @return value
         */
        public ShoppingResponseIDType getShoppingResponseIDs() {
            return shoppingResponseIDs;
        }

        /** 
         * Set the 'ShoppingResponseIDs' element value. Flight-related shopping response IDs, including the unique (master) Shopping Session ID, Offer IDs, Offer Item IDs and Service IDs.
         * 
         * @param shoppingResponseIDs
         */
        public void setShoppingResponseIDs(
                ShoppingResponseIDType shoppingResponseIDs) {
            this.shoppingResponseIDs = shoppingResponseIDs;
        }

        /** 
         * Get the 'MarketingCarrierAirline' element value.
         * 
         * @return value
         */
        public MarketingCarrierType getMarketingCarrierAirline() {
            return marketingCarrierAirline;
        }

        /** 
         * Set the 'MarketingCarrierAirline' element value.
         * 
         * @param marketingCarrierAirline
         */
        public void setMarketingCarrierAirline(
                MarketingCarrierType marketingCarrierAirline) {
            this.marketingCarrierAirline = marketingCarrierAirline;
        }

        /** 
         * Get the 'CalendarDates' element value.
         * 
         * @return value
         */
        public CalendarDates getCalendarDates() {
            return calendarDates;
        }

        /** 
         * Set the 'CalendarDates' element value.
         * 
         * @param calendarDates
         */
        public void setCalendarDates(CalendarDates calendarDates) {
            this.calendarDates = calendarDates;
        }

        /** 
         * Get the 'OriginDestinationKey' attribute value. A globally unique identifier for this OriginDestination instance. Example: origDest1
         * 
         * @return value
         */
        public String getOriginDestinationKey() {
            return originDestinationKey;
        }

        /** 
         * Set the 'OriginDestinationKey' attribute value. A globally unique identifier for this OriginDestination instance. Example: origDest1
         * 
         * @param originDestinationKey
         */
        public void setOriginDestinationKey(String originDestinationKey) {
            this.originDestinationKey = originDestinationKey;
        }
        /** 
         * Indicates a calendar search request with days before and/or days after the specified date.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CalendarDates" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:int" name="DaysBefore"/>
         *     &lt;xs:attribute type="xs:int" name="DaysAfter"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class CalendarDates implements Serializable
        {
            private Integer daysBefore;
            private Integer daysAfter;

            /** 
             * Get the 'DaysBefore' attribute value. Number of days  befiore the specified date.
             * 
             * @return value
             */
            public Integer getDaysBefore() {
                return daysBefore;
            }

            /** 
             * Set the 'DaysBefore' attribute value. Number of days  befiore the specified date.
             * 
             * @param daysBefore
             */
            public void setDaysBefore(Integer daysBefore) {
                this.daysBefore = daysBefore;
            }

            /** 
             * Get the 'DaysAfter' attribute value. Number  of days after the specified date.
             * 
             * @return value
             */
            public Integer getDaysAfter() {
                return daysAfter;
            }

            /** 
             * Set the 'DaysAfter' attribute value. Number  of days after the specified date.
             * 
             * @param daysAfter
             */
            public void setDaysAfter(Integer daysAfter) {
                this.daysAfter = daysAfter;
            }
        }
    }
}
