
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The AirShopping transaction set supports both demanding and flexible shopping experiences for anonymous or personalized shopping.

 The combination of functionally-rich attribute and affinity shopping support date range or specific month (calendar) shopping as an example.

 The response returns offers which may include branded offers or itinerary-priced offers with or without ancillary services. It also returns applicable rules for the integrated fares as well as for each service.

 The message also returns multi-media content at message level as well as media references at the individual offer level.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirShoppingRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:PointOfSale" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element type="ns:AirShopReqParamsType" name="Parameters" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Travelers"/>
 *       &lt;xs:element name="CoreQuery">
 *         &lt;xs:complexType>
 *           &lt;xs:choice>
 *             &lt;xs:element ref="ns:Affinity"/>
 *             &lt;xs:element type="ns:AirShopReqAttributeQueryType" name="OriginDestinations"/>
 *             &lt;xs:element ref="ns:FlightSpecific"/>
 *             &lt;xs:element ref="ns:ShoppingResponseIDs"/>
 *           &lt;/xs:choice>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:element name="Qualifiers" minOccurs="0">
 *         &lt;!-- Reference to inner class Qualifiers -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="Preferences" minOccurs="0">
 *         &lt;!-- Reference to inner class Preferences -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:AirShopReqMetadataType" name="Metadata" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Policies" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class AirShoppingRQ implements Serializable
{
    private PointOfSaleType pointOfSale;
    private MsgDocumentType document;
    private MsgPartiesType party;
    private AirShopReqParamsType parameters;
    private Travelers travelers;
    private int coreQuerySelect = -1;
    private static final int CORE_QUERY_AFFINITY_CHOICE = 0;
    private static final int CORE_QUERY_ORIGIN_DESTINATIONS_CHOICE = 1;
    private static final int CORE_QUERY_FLIGHT_SPECIFIC_CHOICE = 2;
    private static final int CORE_QUERY_SHOPPING_RESPONSE_I_DS_CHOICE = 3;
    private AirShopReqAffinityQueryType coreQueryAffinity;
    private AirShopReqAttributeQueryType coreQueryOriginDestinations;
    private AirShopFlightSpecificType coreQueryFlightSpecific;
    private ShoppingResponseIDType coreQueryShoppingResponseIDs;
    private Qualifiers qualifiers;
    private Preferences preferences;
    private AirShopReqMetadataType metadata;
    private Policies policies;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'PointOfSale' element value.
     * 
     * @return value
     */
    public PointOfSaleType getPointOfSale() {
        return pointOfSale;
    }

    /** 
     * Set the 'PointOfSale' element value.
     * 
     * @param pointOfSale
     */
    public void setPointOfSale(PointOfSaleType pointOfSale) {
        this.pointOfSale = pointOfSale;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Get the 'Parameters' element value. Parameters that influence overall message results.

    Supported Parameter Groups: Inventory Guarantee (offer-associated); Service Filter (offer-associated); Pricing.

    Note: These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification. 
     * 
     * @return value
     */
    public AirShopReqParamsType getParameters() {
        return parameters;
    }

    /** 
     * Set the 'Parameters' element value. Parameters that influence overall message results.

    Supported Parameter Groups: Inventory Guarantee (offer-associated); Service Filter (offer-associated); Pricing.

    Note: These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification. 
     * 
     * @param parameters
     */
    public void setParameters(AirShopReqParamsType parameters) {
        this.parameters = parameters;
    }

    /** 
     * Get the 'Travelers' element value.
     * 
     * @return value
     */
    public Travelers getTravelers() {
        return travelers;
    }

    /** 
     * Set the 'Travelers' element value.
     * 
     * @param travelers
     */
    public void setTravelers(Travelers travelers) {
        this.travelers = travelers;
    }

    private void setCoreQuerySelect(int choice) {
        if (coreQuerySelect == -1) {
            coreQuerySelect = choice;
        } else if (coreQuerySelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearCoreQuerySelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearCoreQuerySelect() {
        coreQuerySelect = -1;
    }

    /** 
     * Check if CoreQueryAffinity is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCoreQueryAffinity() {
        return coreQuerySelect == CORE_QUERY_AFFINITY_CHOICE;
    }

    /** 
     * Get the 'Affinity' element value.
     * 
     * @return value
     */
    public AirShopReqAffinityQueryType getCoreQueryAffinity() {
        return coreQueryAffinity;
    }

    /** 
     * Set the 'Affinity' element value.
     * 
     * @param coreQueryAffinity
     */
    public void setCoreQueryAffinity(
            AirShopReqAffinityQueryType coreQueryAffinity) {
        setCoreQuerySelect(CORE_QUERY_AFFINITY_CHOICE);
        this.coreQueryAffinity = coreQueryAffinity;
    }

    /** 
     * Check if CoreQueryOriginDestinations is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCoreQueryOriginDestinations() {
        return coreQuerySelect == CORE_QUERY_ORIGIN_DESTINATIONS_CHOICE;
    }

    /** 
     * Get the 'OriginDestinations' element value. ATTRIBUTE Query ORIGIN/ DESTINATION qualifiers and preferences.

    Note:
    1. An Attribute Query is a search specifying one or more attributes to get more focused results   Note that this node only contains Origin/ Destination Airport/ City code information which are mandatory.

    2. Other Attribute Query parameters that may be specified (in other document nodes) include Aircraft Equipment preferences, Seat types and characteristics, Meal preferences and Special Need qualifiers.
     * 
     * @return value
     */
    public AirShopReqAttributeQueryType getCoreQueryOriginDestinations() {
        return coreQueryOriginDestinations;
    }

    /** 
     * Set the 'OriginDestinations' element value. ATTRIBUTE Query ORIGIN/ DESTINATION qualifiers and preferences.

    Note:
    1. An Attribute Query is a search specifying one or more attributes to get more focused results   Note that this node only contains Origin/ Destination Airport/ City code information which are mandatory.

    2. Other Attribute Query parameters that may be specified (in other document nodes) include Aircraft Equipment preferences, Seat types and characteristics, Meal preferences and Special Need qualifiers.
     * 
     * @param coreQueryOriginDestinations
     */
    public void setCoreQueryOriginDestinations(
            AirShopReqAttributeQueryType coreQueryOriginDestinations) {
        setCoreQuerySelect(CORE_QUERY_ORIGIN_DESTINATIONS_CHOICE);
        this.coreQueryOriginDestinations = coreQueryOriginDestinations;
    }

    /** 
     * Check if CoreQueryFlightSpecific is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCoreQueryFlightSpecific() {
        return coreQuerySelect == CORE_QUERY_FLIGHT_SPECIFIC_CHOICE;
    }

    /** 
     * Get the 'FlightSpecific' element value.
     * 
     * @return value
     */
    public AirShopFlightSpecificType getCoreQueryFlightSpecific() {
        return coreQueryFlightSpecific;
    }

    /** 
     * Set the 'FlightSpecific' element value.
     * 
     * @param coreQueryFlightSpecific
     */
    public void setCoreQueryFlightSpecific(
            AirShopFlightSpecificType coreQueryFlightSpecific) {
        setCoreQuerySelect(CORE_QUERY_FLIGHT_SPECIFIC_CHOICE);
        this.coreQueryFlightSpecific = coreQueryFlightSpecific;
    }

    /** 
     * Check if CoreQueryShoppingResponseIDs is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCoreQueryShoppingResponseIDs() {
        return coreQuerySelect == CORE_QUERY_SHOPPING_RESPONSE_I_DS_CHOICE;
    }

    /** 
     * Get the 'ShoppingResponseIDs' element value.
     * 
     * @return value
     */
    public ShoppingResponseIDType getCoreQueryShoppingResponseIDs() {
        return coreQueryShoppingResponseIDs;
    }

    /** 
     * Set the 'ShoppingResponseIDs' element value.
     * 
     * @param coreQueryShoppingResponseIDs
     */
    public void setCoreQueryShoppingResponseIDs(
            ShoppingResponseIDType coreQueryShoppingResponseIDs) {
        setCoreQuerySelect(CORE_QUERY_SHOPPING_RESPONSE_I_DS_CHOICE);
        this.coreQueryShoppingResponseIDs = coreQueryShoppingResponseIDs;
    }

    /** 
     * Get the 'Qualifiers' element value.
     * 
     * @return value
     */
    public Qualifiers getQualifiers() {
        return qualifiers;
    }

    /** 
     * Set the 'Qualifiers' element value.
     * 
     * @param qualifiers
     */
    public void setQualifiers(Qualifiers qualifiers) {
        this.qualifiers = qualifiers;
    }

    /** 
     * Get the 'Preferences' element value.
     * 
     * @return value
     */
    public Preferences getPreferences() {
        return preferences;
    }

    /** 
     * Set the 'Preferences' element value.
     * 
     * @param preferences
     */
    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    /** 
     * Get the 'Metadata' element value. Metadata List(s).
     * 
     * @return value
     */
    public AirShopReqMetadataType getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value. Metadata List(s).
     * 
     * @param metadata
     */
    public void setMetadata(AirShopReqMetadataType metadata) {
        this.metadata = metadata;
    }

    /** 
     * Get the 'Policies' element value. Message Policy information.
     * 
     * @return value
     */
    public Policies getPolicies() {
        return policies;
    }

    /** 
     * Set the 'Policies' element value. Message Policy information.
     * 
     * @param policies
     */
    public void setPolicies(Policies policies) {
        this.policies = policies;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Traveler requested qualifiers to influence search results (e.g. offers and/ or offer pricing), including Payment Card, Programs, Promotions, Social Media, Special Fares and Special Needs.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Qualifiers" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Qualifier" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Qualifier -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Qualifiers implements Serializable
    {
        private List<Qualifier> qualifierList = new ArrayList<Qualifier>();

        /** 
         * Get the list of 'Qualifier' element items.
         * 
         * @return list
         */
        public List<Qualifier> getQualifierList() {
            return qualifierList;
        }

        /** 
         * Set the list of 'Qualifier' element items.
         * 
         * @param list
         */
        public void setQualifierList(List<Qualifier> list) {
            qualifierList = list;
        }
        /** 
         * Qualifier choices.

        Notes: 
        1. These qualifiers may be specified for (e.g. apply to) both Attribute and Affinity queries.
        2. These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of the capability is not dictated by this specification. 
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Qualifier" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:choice>
         *       &lt;xs:element ref="ns:BaggagePricingQualifier"/>
         *       &lt;xs:element ref="ns:ExistingOrderQualifier"/>
         *       &lt;xs:element ref="ns:PaymentCardQualifiers"/>
         *       &lt;xs:element ref="ns:ProgramQualifiers"/>
         *       &lt;xs:element ref="ns:PromotionQualifiers"/>
         *       &lt;xs:element ref="ns:SeatQualifier"/>
         *       &lt;xs:element ref="ns:ServiceQualifier"/>
         *       &lt;xs:element ref="ns:SocialMediaQualifiers"/>
         *       &lt;xs:element ref="ns:SpecialFareQualifiers"/>
         *       &lt;xs:element ref="ns:SpecialNeedQualifiers"/>
         *       &lt;xs:element ref="ns:TripPurposeQualifier"/>
         *     &lt;/xs:choice>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Qualifier implements Serializable
        {
            private int qualifierListSelect = -1;
            private static final int BAGGAGE_PRICING_QUALIFIER_CHOICE = 0;
            private static final int EXISTING_ORDER_QUALIFIER_CHOICE = 1;
            private static final int PAYMENT_CARD_QUALIFIERS_CHOICE = 2;
            private static final int PROGRAM_QUALIFIERS_CHOICE = 3;
            private static final int PROMOTION_QUALIFIERS_CHOICE = 4;
            private static final int SEAT_QUALIFIER_CHOICE = 5;
            private static final int SERVICE_QUALIFIER_CHOICE = 6;
            private static final int SOCIAL_MEDIA_QUALIFIERS_CHOICE = 7;
            private static final int SPECIAL_FARE_QUALIFIERS_CHOICE = 8;
            private static final int SPECIAL_NEED_QUALIFIERS_CHOICE = 9;
            private static final int TRIP_PURPOSE_QUALIFIER_CHOICE = 10;
            private BaggagePricingQualifierType baggagePricingQualifier;
            private ExistingOrderQualifier existingOrderQualifier;
            private CardQualifierType paymentCardQualifiers;
            private ProgramQualifiers programQualifiers;
            private PromotionQualifiers promotionQualifiers;
            private SeatQualifier seatQualifier;
            private ServiceQualifierPriceType serviceQualifier;
            private SocialMediaQualifierType socialMediaQualifiers;
            private FareQualifierType specialFareQualifiers;
            private SpecialType specialNeedQualifiers;
            private TripPurposeQualifier tripPurposeQualifier;

            private void setQualifierListSelect(int choice) {
                if (qualifierListSelect == -1) {
                    qualifierListSelect = choice;
                } else if (qualifierListSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearQualifierListSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearQualifierListSelect() {
                qualifierListSelect = -1;
            }

            /** 
             * Check if BaggagePricingQualifier is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifBaggagePricingQualifier() {
                return qualifierListSelect == BAGGAGE_PRICING_QUALIFIER_CHOICE;
            }

            /** 
             * Get the 'BaggagePricingQualifier' element value.
             * 
             * @return value
             */
            public BaggagePricingQualifierType getBaggagePricingQualifier() {
                return baggagePricingQualifier;
            }

            /** 
             * Set the 'BaggagePricingQualifier' element value.
             * 
             * @param baggagePricingQualifier
             */
            public void setBaggagePricingQualifier(
                    BaggagePricingQualifierType baggagePricingQualifier) {
                setQualifierListSelect(BAGGAGE_PRICING_QUALIFIER_CHOICE);
                this.baggagePricingQualifier = baggagePricingQualifier;
            }

            /** 
             * Check if ExistingOrderQualifier is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifExistingOrderQualifier() {
                return qualifierListSelect == EXISTING_ORDER_QUALIFIER_CHOICE;
            }

            /** 
             * Get the 'ExistingOrderQualifier' element value.
             * 
             * @return value
             */
            public ExistingOrderQualifier getExistingOrderQualifier() {
                return existingOrderQualifier;
            }

            /** 
             * Set the 'ExistingOrderQualifier' element value.
             * 
             * @param existingOrderQualifier
             */
            public void setExistingOrderQualifier(
                    ExistingOrderQualifier existingOrderQualifier) {
                setQualifierListSelect(EXISTING_ORDER_QUALIFIER_CHOICE);
                this.existingOrderQualifier = existingOrderQualifier;
            }

            /** 
             * Check if PaymentCardQualifiers is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifPaymentCardQualifiers() {
                return qualifierListSelect == PAYMENT_CARD_QUALIFIERS_CHOICE;
            }

            /** 
             * Get the 'PaymentCardQualifiers' element value.
             * 
             * @return value
             */
            public CardQualifierType getPaymentCardQualifiers() {
                return paymentCardQualifiers;
            }

            /** 
             * Set the 'PaymentCardQualifiers' element value.
             * 
             * @param paymentCardQualifiers
             */
            public void setPaymentCardQualifiers(
                    CardQualifierType paymentCardQualifiers) {
                setQualifierListSelect(PAYMENT_CARD_QUALIFIERS_CHOICE);
                this.paymentCardQualifiers = paymentCardQualifiers;
            }

            /** 
             * Check if ProgramQualifiers is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifProgramQualifiers() {
                return qualifierListSelect == PROGRAM_QUALIFIERS_CHOICE;
            }

            /** 
             * Get the 'ProgramQualifiers' element value.
             * 
             * @return value
             */
            public ProgramQualifiers getProgramQualifiers() {
                return programQualifiers;
            }

            /** 
             * Set the 'ProgramQualifiers' element value.
             * 
             * @param programQualifiers
             */
            public void setProgramQualifiers(ProgramQualifiers programQualifiers) {
                setQualifierListSelect(PROGRAM_QUALIFIERS_CHOICE);
                this.programQualifiers = programQualifiers;
            }

            /** 
             * Check if PromotionQualifiers is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifPromotionQualifiers() {
                return qualifierListSelect == PROMOTION_QUALIFIERS_CHOICE;
            }

            /** 
             * Get the 'PromotionQualifiers' element value.
             * 
             * @return value
             */
            public PromotionQualifiers getPromotionQualifiers() {
                return promotionQualifiers;
            }

            /** 
             * Set the 'PromotionQualifiers' element value.
             * 
             * @param promotionQualifiers
             */
            public void setPromotionQualifiers(
                    PromotionQualifiers promotionQualifiers) {
                setQualifierListSelect(PROMOTION_QUALIFIERS_CHOICE);
                this.promotionQualifiers = promotionQualifiers;
            }

            /** 
             * Check if SeatQualifier is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifSeatQualifier() {
                return qualifierListSelect == SEAT_QUALIFIER_CHOICE;
            }

            /** 
             * Get the 'SeatQualifier' element value.
             * 
             * @return value
             */
            public SeatQualifier getSeatQualifier() {
                return seatQualifier;
            }

            /** 
             * Set the 'SeatQualifier' element value.
             * 
             * @param seatQualifier
             */
            public void setSeatQualifier(SeatQualifier seatQualifier) {
                setQualifierListSelect(SEAT_QUALIFIER_CHOICE);
                this.seatQualifier = seatQualifier;
            }

            /** 
             * Check if ServiceQualifier is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifServiceQualifier() {
                return qualifierListSelect == SERVICE_QUALIFIER_CHOICE;
            }

            /** 
             * Get the 'ServiceQualifier' element value.
             * 
             * @return value
             */
            public ServiceQualifierPriceType getServiceQualifier() {
                return serviceQualifier;
            }

            /** 
             * Set the 'ServiceQualifier' element value.
             * 
             * @param serviceQualifier
             */
            public void setServiceQualifier(
                    ServiceQualifierPriceType serviceQualifier) {
                setQualifierListSelect(SERVICE_QUALIFIER_CHOICE);
                this.serviceQualifier = serviceQualifier;
            }

            /** 
             * Check if SocialMediaQualifiers is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifSocialMediaQualifiers() {
                return qualifierListSelect == SOCIAL_MEDIA_QUALIFIERS_CHOICE;
            }

            /** 
             * Get the 'SocialMediaQualifiers' element value.
             * 
             * @return value
             */
            public SocialMediaQualifierType getSocialMediaQualifiers() {
                return socialMediaQualifiers;
            }

            /** 
             * Set the 'SocialMediaQualifiers' element value.
             * 
             * @param socialMediaQualifiers
             */
            public void setSocialMediaQualifiers(
                    SocialMediaQualifierType socialMediaQualifiers) {
                setQualifierListSelect(SOCIAL_MEDIA_QUALIFIERS_CHOICE);
                this.socialMediaQualifiers = socialMediaQualifiers;
            }

            /** 
             * Check if SpecialFareQualifiers is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifSpecialFareQualifiers() {
                return qualifierListSelect == SPECIAL_FARE_QUALIFIERS_CHOICE;
            }

            /** 
             * Get the 'SpecialFareQualifiers' element value.
             * 
             * @return value
             */
            public FareQualifierType getSpecialFareQualifiers() {
                return specialFareQualifiers;
            }

            /** 
             * Set the 'SpecialFareQualifiers' element value.
             * 
             * @param specialFareQualifiers
             */
            public void setSpecialFareQualifiers(
                    FareQualifierType specialFareQualifiers) {
                setQualifierListSelect(SPECIAL_FARE_QUALIFIERS_CHOICE);
                this.specialFareQualifiers = specialFareQualifiers;
            }

            /** 
             * Check if SpecialNeedQualifiers is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifSpecialNeedQualifiers() {
                return qualifierListSelect == SPECIAL_NEED_QUALIFIERS_CHOICE;
            }

            /** 
             * Get the 'SpecialNeedQualifiers' element value.
             * 
             * @return value
             */
            public SpecialType getSpecialNeedQualifiers() {
                return specialNeedQualifiers;
            }

            /** 
             * Set the 'SpecialNeedQualifiers' element value.
             * 
             * @param specialNeedQualifiers
             */
            public void setSpecialNeedQualifiers(
                    SpecialType specialNeedQualifiers) {
                setQualifierListSelect(SPECIAL_NEED_QUALIFIERS_CHOICE);
                this.specialNeedQualifiers = specialNeedQualifiers;
            }

            /** 
             * Check if TripPurposeQualifier is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifTripPurposeQualifier() {
                return qualifierListSelect == TRIP_PURPOSE_QUALIFIER_CHOICE;
            }

            /** 
             * Get the 'TripPurposeQualifier' element value.
             * 
             * @return value
             */
            public TripPurposeQualifier getTripPurposeQualifier() {
                return tripPurposeQualifier;
            }

            /** 
             * Set the 'TripPurposeQualifier' element value.
             * 
             * @param tripPurposeQualifier
             */
            public void setTripPurposeQualifier(
                    TripPurposeQualifier tripPurposeQualifier) {
                setQualifierListSelect(TRIP_PURPOSE_QUALIFIER_CHOICE);
                this.tripPurposeQualifier = tripPurposeQualifier;
            }
        }
    }
    /** 
     * Shopping Preference(s), including Airline Supplier, Alliance Program, Fare, Flight and Transfer/ Connection Points.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Preferences" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Preference" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Preference -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Preferences implements Serializable
    {
        private List<Preference> preferenceList = new ArrayList<Preference>();

        /** 
         * Get the list of 'Preference' element items.
         * 
         * @return list
         */
        public List<Preference> getPreferenceList() {
            return preferenceList;
        }

        /** 
         * Set the list of 'Preference' element items.
         * 
         * @param list
         */
        public void setPreferenceList(List<Preference> list) {
            preferenceList = list;
        }
        /** 
         * Preference choices.

        Notes: 
        1. These preferences may be specified for (e.g. apply to) both Attribute and Affinity queries.
        2. These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of the capability is not dictated by this specification. 
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Preference" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:choice>
         *       &lt;xs:element ref="ns:AirlinePreferences"/>
         *       &lt;xs:element ref="ns:AlliancePreferences"/>
         *       &lt;xs:element ref="ns:FarePreferences"/>
         *       &lt;xs:element ref="ns:FlightPreferences"/>
         *       &lt;xs:element ref="ns:PricingMethodPreference"/>
         *       &lt;xs:element ref="ns:SegMaxTimePreferences"/>
         *       &lt;xs:element ref="ns:ServicePricingOnlyPreference"/>
         *       &lt;xs:element ref="ns:TransferPreferences"/>
         *       &lt;xs:element ref="ns:CabinPreferences"/>
         *     &lt;/xs:choice>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Preference implements Serializable
        {
            private int preferenceListSelect = -1;
            private static final int AIRLINE_PREFERENCES_CHOICE = 0;
            private static final int ALLIANCE_PREFERENCES_CHOICE = 1;
            private static final int FARE_PREFERENCES_CHOICE = 2;
            private static final int FLIGHT_PREFERENCES_CHOICE = 3;
            private static final int PRICING_METHOD_PREFERENCE_CHOICE = 4;
            private static final int SEG_MAX_TIME_PREFERENCES_CHOICE = 5;
            private static final int SERVICE_PRICING_ONLY_PREFERENCE_CHOICE = 6;
            private static final int TRANSFER_PREFERENCES_CHOICE = 7;
            private static final int CABIN_PREFERENCES_CHOICE = 8;
            private AirlinePreferencesType airlinePreferences;
            private AlliancePreferencesType alliancePreferences;
            private FarePreferencesType farePreferences;
            private FlightPreferencesType flightPreferences;
            private BestPricingPreferencesType pricingMethodPreference;
            private FltSegmentMaxTimePreferencesType segMaxTimePreferences;
            private ServicePricingOnlyPreference servicePricingOnlyPreference;
            private TransferPreferencesType transferPreferences;
            private CabinPreferencesType cabinPreferences;

            private void setPreferenceListSelect(int choice) {
                if (preferenceListSelect == -1) {
                    preferenceListSelect = choice;
                } else if (preferenceListSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearPreferenceListSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearPreferenceListSelect() {
                preferenceListSelect = -1;
            }

            /** 
             * Check if AirlinePreferences is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifAirlinePreferences() {
                return preferenceListSelect == AIRLINE_PREFERENCES_CHOICE;
            }

            /** 
             * Get the 'AirlinePreferences' element value.
             * 
             * @return value
             */
            public AirlinePreferencesType getAirlinePreferences() {
                return airlinePreferences;
            }

            /** 
             * Set the 'AirlinePreferences' element value.
             * 
             * @param airlinePreferences
             */
            public void setAirlinePreferences(
                    AirlinePreferencesType airlinePreferences) {
                setPreferenceListSelect(AIRLINE_PREFERENCES_CHOICE);
                this.airlinePreferences = airlinePreferences;
            }

            /** 
             * Check if AlliancePreferences is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifAlliancePreferences() {
                return preferenceListSelect == ALLIANCE_PREFERENCES_CHOICE;
            }

            /** 
             * Get the 'AlliancePreferences' element value.
             * 
             * @return value
             */
            public AlliancePreferencesType getAlliancePreferences() {
                return alliancePreferences;
            }

            /** 
             * Set the 'AlliancePreferences' element value.
             * 
             * @param alliancePreferences
             */
            public void setAlliancePreferences(
                    AlliancePreferencesType alliancePreferences) {
                setPreferenceListSelect(ALLIANCE_PREFERENCES_CHOICE);
                this.alliancePreferences = alliancePreferences;
            }

            /** 
             * Check if FarePreferences is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifFarePreferences() {
                return preferenceListSelect == FARE_PREFERENCES_CHOICE;
            }

            /** 
             * Get the 'FarePreferences' element value.
             * 
             * @return value
             */
            public FarePreferencesType getFarePreferences() {
                return farePreferences;
            }

            /** 
             * Set the 'FarePreferences' element value.
             * 
             * @param farePreferences
             */
            public void setFarePreferences(FarePreferencesType farePreferences) {
                setPreferenceListSelect(FARE_PREFERENCES_CHOICE);
                this.farePreferences = farePreferences;
            }

            /** 
             * Check if FlightPreferences is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifFlightPreferences() {
                return preferenceListSelect == FLIGHT_PREFERENCES_CHOICE;
            }

            /** 
             * Get the 'FlightPreferences' element value.
             * 
             * @return value
             */
            public FlightPreferencesType getFlightPreferences() {
                return flightPreferences;
            }

            /** 
             * Set the 'FlightPreferences' element value.
             * 
             * @param flightPreferences
             */
            public void setFlightPreferences(
                    FlightPreferencesType flightPreferences) {
                setPreferenceListSelect(FLIGHT_PREFERENCES_CHOICE);
                this.flightPreferences = flightPreferences;
            }

            /** 
             * Check if PricingMethodPreference is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifPricingMethodPreference() {
                return preferenceListSelect == PRICING_METHOD_PREFERENCE_CHOICE;
            }

            /** 
             * Get the 'PricingMethodPreference' element value.
             * 
             * @return value
             */
            public BestPricingPreferencesType getPricingMethodPreference() {
                return pricingMethodPreference;
            }

            /** 
             * Set the 'PricingMethodPreference' element value.
             * 
             * @param pricingMethodPreference
             */
            public void setPricingMethodPreference(
                    BestPricingPreferencesType pricingMethodPreference) {
                setPreferenceListSelect(PRICING_METHOD_PREFERENCE_CHOICE);
                this.pricingMethodPreference = pricingMethodPreference;
            }

            /** 
             * Check if SegMaxTimePreferences is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifSegMaxTimePreferences() {
                return preferenceListSelect == SEG_MAX_TIME_PREFERENCES_CHOICE;
            }

            /** 
             * Get the 'SegMaxTimePreferences' element value.
             * 
             * @return value
             */
            public FltSegmentMaxTimePreferencesType getSegMaxTimePreferences() {
                return segMaxTimePreferences;
            }

            /** 
             * Set the 'SegMaxTimePreferences' element value.
             * 
             * @param segMaxTimePreferences
             */
            public void setSegMaxTimePreferences(
                    FltSegmentMaxTimePreferencesType segMaxTimePreferences) {
                setPreferenceListSelect(SEG_MAX_TIME_PREFERENCES_CHOICE);
                this.segMaxTimePreferences = segMaxTimePreferences;
            }

            /** 
             * Check if ServicePricingOnlyPreference is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifServicePricingOnlyPreference() {
                return preferenceListSelect == SERVICE_PRICING_ONLY_PREFERENCE_CHOICE;
            }

            /** 
             * Get the 'ServicePricingOnlyPreference' element value.
             * 
             * @return value
             */
            public ServicePricingOnlyPreference getServicePricingOnlyPreference() {
                return servicePricingOnlyPreference;
            }

            /** 
             * Set the 'ServicePricingOnlyPreference' element value.
             * 
             * @param servicePricingOnlyPreference
             */
            public void setServicePricingOnlyPreference(
                    ServicePricingOnlyPreference servicePricingOnlyPreference) {
                setPreferenceListSelect(SERVICE_PRICING_ONLY_PREFERENCE_CHOICE);
                this.servicePricingOnlyPreference = servicePricingOnlyPreference;
            }

            /** 
             * Check if TransferPreferences is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifTransferPreferences() {
                return preferenceListSelect == TRANSFER_PREFERENCES_CHOICE;
            }

            /** 
             * Get the 'TransferPreferences' element value.
             * 
             * @return value
             */
            public TransferPreferencesType getTransferPreferences() {
                return transferPreferences;
            }

            /** 
             * Set the 'TransferPreferences' element value.
             * 
             * @param transferPreferences
             */
            public void setTransferPreferences(
                    TransferPreferencesType transferPreferences) {
                setPreferenceListSelect(TRANSFER_PREFERENCES_CHOICE);
                this.transferPreferences = transferPreferences;
            }

            /** 
             * Check if CabinPreferences is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifCabinPreferences() {
                return preferenceListSelect == CABIN_PREFERENCES_CHOICE;
            }

            /** 
             * Get the 'CabinPreferences' element value.
             * 
             * @return value
             */
            public CabinPreferencesType getCabinPreferences() {
                return cabinPreferences;
            }

            /** 
             * Set the 'CabinPreferences' element value.
             * 
             * @param cabinPreferences
             */
            public void setCabinPreferences(
                    CabinPreferencesType cabinPreferences) {
                setPreferenceListSelect(CABIN_PREFERENCES_CHOICE);
                this.cabinPreferences = cabinPreferences;
            }
        }
    }
}
