
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * AIRCRAFT FEATURES QUERY representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AircraftFeaturesQueryType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Feature" maxOccurs="unbounded">
 *           &lt;!-- Reference to inner class Feature -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AircraftFeaturesQueryType extends KeyWithMetaObjectBaseType
    implements Serializable
{
    private List<Feature> featureList = new ArrayList<Feature>();

    /** 
     * Get the list of 'Feature' element items.
     * 
     * @return list
     */
    public List<Feature> getFeatureList() {
        return featureList;
    }

    /** 
     * Set the list of 'Feature' element items.
     * 
     * @param list
     */
    public void setFeatureList(List<Feature> list) {
        featureList = list;
    }
    /** 
     * Aircraft feature detail.

    Encoding Scheme: IATA PADIS Codeset AFT (Aircraft Feature Type)
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Feature" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:CodesetType">
     *         &lt;xs:attributeGroup ref="ns:PreferenceAttrGroup"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Feature extends CodesetType implements Serializable
    {
        private PreferenceAttrGroup preferenceAttrGroup;

        /** 
         * Get the 'PreferenceAttrGroup' attributeGroup value.
         * 
         * @return value
         */
        public PreferenceAttrGroup getPreferenceAttrGroup() {
            return preferenceAttrGroup;
        }

        /** 
         * Set the 'PreferenceAttrGroup' attributeGroup value.
         * 
         * @param preferenceAttrGroup
         */
        public void setPreferenceAttrGroup(
                PreferenceAttrGroup preferenceAttrGroup) {
            this.preferenceAttrGroup = preferenceAttrGroup;
        }
    }
}
