
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for AIRCRAFT Metadata.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AircraftMetadataType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:MetadataObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="TailNumber" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AircraftMetadataType extends MetadataObjectBaseType implements
    Serializable
{
    private String tailNumber;
    private String name;

    /** 
     * Get the 'TailNumber' element value. Aircraft tail number.  Example: N387SW
     * 
     * @return value
     */
    public String getTailNumber() {
        return tailNumber;
    }

    /** 
     * Set the 'TailNumber' element value. Aircraft tail number.  Example: N387SW
     * 
     * @param tailNumber
     */
    public void setTailNumber(String tailNumber) {
        this.tailNumber = tailNumber;
    }

    /** 
     * Get the 'Name' element value. Aircraft name.Example: N387SW
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Aircraft name.Example: N387SW
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }
}
