
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Airport Code Role contextual list.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirportCodeRoleSimpleType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Arrival_Destination"/>
 *     &lt;xs:enumeration value="Connection"/>
 *     &lt;xs:enumeration value="Departure_Origin"/>
 *     &lt;xs:enumeration value="Stop"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum AirportCodeRoleSimpleType implements Serializable {
    ARRIVAL_DESTINATION("Arrival_Destination"), CONNECTION("Connection"), DEPARTURE_ORIGIN(
            "Departure_Origin"), STOP("Stop");
    private final String value;

    private AirportCodeRoleSimpleType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static AirportCodeRoleSimpleType convert(String value) {
        for (AirportCodeRoleSimpleType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
